/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.teamcity.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.teamcity.action.ActionGroupImpl;
import jetbrains.charisma.teamcity.persistence.TeamcityChangeDTO;
import jetbrains.charisma.teamcity.persistence.TeamcityChangesProcessingOptionImpl;
import jetbrains.charisma.teamcity.persistence.TeamcityServerImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeArithmetics;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.buildservers.BuildsProvider;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;
import jetbrains.youtrack.integration.build.BuildServerImpl;
import jetbrains.youtrack.integration.build.BuildStatus;
import jetbrains.youtrack.integration.build.BuildsProcessorImpl;
import jetbrains.youtrack.integration.build.CommonBuildDTO;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import org.joda.time.DateTimeFieldType;

public class TeamcityBuildConfMappingImpl
extends BuildsProcessorImpl {
    private static String __ENTITY_TYPE__ = "TeamcityBuildConfMapping";

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"server", (Entity)TeamcityServerImpl.getDefault());
        Entity branchActions2 = ActionGroupImpl.constructor(entity);
        PrimitiveAssociationSemantics.set((Entity)branchActions2, (String)"processRelatedIssues", (Comparable)Boolean.valueOf(true), Boolean.class);
        PrimitiveAssociationSemantics.set((Entity)branchActions2, (String)"query", (Comparable)((Object)((BuildsProvider)ServiceLocator.getBean((String)"buildsProvider")).getDefaultBuildMappingQuery()), String.class);
        PrimitiveAssociationSemantics.set((Entity)branchActions2, (String)"processMatchingIssues", (Comparable)Boolean.valueOf(true), Boolean.class);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"defaultBranchActions", (Entity)branchActions2);
        branchActions2 = ActionGroupImpl.constructor(entity);
        PrimitiveAssociationSemantics.set((Entity)branchActions2, (String)"processRelatedIssues", (Comparable)Boolean.valueOf(false), Boolean.class);
        PrimitiveAssociationSemantics.set((Entity)branchActions2, (String)"query", (Comparable)((Object)((BuildsProvider)ServiceLocator.getBean((String)"buildsProvider")).getDefaultBuildMappingQuery()), String.class);
        PrimitiveAssociationSemantics.set((Entity)branchActions2, (String)"processMatchingIssues", (Comparable)Boolean.valueOf(false), Boolean.class);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"featureBranchActions", (Entity)branchActions2);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"changesProcessingOption", (Entity)TeamcityChangesProcessingOptionImpl.ATTACH_AND_APPLY_COMMANDS.get());
        this.reset(entity);
        return entity;
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"defaultBranchActions"), (String)"buildField"), null) && !QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"fields"), (Entity)AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"defaultBranchActions"), (String)"buildField")) || !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"featureBranchActions"), (String)"buildField"), null) && !QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"fields"), (Entity)AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"featureBranchActions"), (String)"buildField"))) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Selected_build_field_is_not_a_custom_field_of_selected_project", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Selected_build_field_is_not_a_custom_field_of_selected_project", new Object[0]), (Entity)((TransientEntity)entity)));
        }
        if (TeamcityBuildConfMappingImpl.neq_ad96q_a0c0c(PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityBuildTypeId", String.class, null), PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"teamcityBuildTypeId", String.class, null))) {
            ((TeamcityBuildConfMappingImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityBuildConfMapping")).reset(entity);
        }
    }

    public void reset(Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityLastChangeId", (Comparable)Integer.valueOf(-1), Long.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"taxidermy", (Comparable)Boolean.valueOf(true), Boolean.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"buildTaxidermy", (Comparable)Boolean.valueOf(true), Boolean.class);
        this.setLastBuild(null, entity);
    }

    protected void doProcess(_FunctionTypes._return_P1_E0<? extends Iterable<CommonChangeDTO>, ? super Entity> changesProvider, Entity entity) {
        this.syncNames(entity);
        this.setProgressMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Process_VCS_changes_since_{0}", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityLastChangeId", Long.class, null)}), entity);
        super.doProcess(changesProvider, entity);
        this.processBuilds(entity);
    }

    public void syncNames(Entity entity) {
        this.setProgressMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Sync_project_and_build_type_names", new Object[0]), entity);
        try {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityProjectName", (Comparable)((Object)((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"TeamcityServer"), (String)"TeamcityServer")).getProjectName((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityProjectId", String.class, null), DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"TeamcityServer"))), String.class);
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityBuildTypeName", (Comparable)((Object)((BuildServerImpl)DnqUtils.getPersistentClassInstance((Entity)DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"BuildServer"), (String)"BuildServer")).getBuildTypeName((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityBuildTypeId", String.class, null), DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"BuildServer"))), String.class);
        }
        catch (Exception e) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logException(e, "Failed to synchronize names", false, true, entity);
        }
    }

    public void processBuilds(final Entity entity) {
        int allowToRetrieve = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityLastBuildId", Long.class, null) == -1L ? 1000 : Integer.MAX_VALUE;
        try {
            IListSequence builds;
            do {
                final boolean lastBuildDateUnknown = DateTimeOperations.compare((Long)((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityLastBuildAssembled", null)), (CompareType)CompareType.EQ, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond());
                builds = Sequence.fromIterable((Iterable)((BuildServerImpl)DnqUtils.getPersistentClassInstance((Entity)DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"BuildServer"), (String)"BuildServer")).getBuilds(entity, DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"BuildServer"))).where((_FunctionTypes._return_P1_E0)new IWhereFilter<CommonBuildDTO>(){

                    public boolean accept(CommonBuildDTO it) {
                        return it.id > (lastBuildDateUnknown ? (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityLastBuildId", Long.class, null) - 1L : (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityLastBuildId", Long.class, null));
                    }
                }).toListSequence();
                if (Sequence.fromIterable((Iterable)builds).isEmpty()) {
                    ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("No builds found legible for processing", entity);
                    PrimitiveAssociationSemantics.set((Entity)entity, (String)"buildTaxidermy", (Comparable)Boolean.valueOf(false), Boolean.class);
                    return;
                }
                if (lastBuildDateUnknown) {
                    IListSequence list = Sequence.fromIterable((Iterable)builds).toListSequence();
                    PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityLastBuildAssembled", (Comparable)((CommonBuildDTO)ListSequence.fromList((List)list).removeElementAt((int)0)).start);
                    ListSequence.fromList((List)list).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<CommonBuildDTO>(){

                        public void visit(CommonBuildDTO build) {
                            ((TeamcityBuildConfMappingImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityBuildConfMapping")).processBuild(build, entity);
                        }
                    });
                    continue;
                }
                Sequence.fromIterable((Iterable)builds).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<CommonBuildDTO>(){

                    public void visit(CommonBuildDTO build) {
                        ((TeamcityBuildConfMappingImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityBuildConfMapping")).processBuild(build, entity);
                    }
                });
            } while (Sequence.fromIterable((Iterable)builds).count() == 100 && (allowToRetrieve -= Sequence.fromIterable((Iterable)builds).count()) > 0);
        }
        catch (Exception e) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logException(e, "Exception while processing builds", true, true, entity);
        }
    }

    private void processBuild(CommonBuildDTO build, Entity entity) {
        Entity action;
        this.setProgressMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Process_TeamCity_build_{0}", new Object[]{build.number}), entity);
        Entity entity2 = action = build.branch == null || build.defaultBranch ? AssociationSemantics.getToOne((Entity)entity, (String)"defaultBranchActions") : AssociationSemantics.getToOne((Entity)entity, (String)"featureBranchActions");
        if (EntityOperations.equals((Entity)action, null)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Build " + build.number + ". No action found for branch " + build.branch, entity);
        } else {
            String branchString;
            String string = branchString = EntityOperations.equals((Entity)action, (Object)AssociationSemantics.getToOne((Entity)entity, (String)"defaultBranchActions")) ? "default branch" : "feature branch " + build.branch;
            if (build.status == BuildStatus.FAILED && !((Boolean)PrimitiveAssociationSemantics.get((Entity)action, (String)"processRedBuilds", Boolean.class, null)).booleanValue()) {
                ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Build " + build.number + " assembled from " + branchString + "has 'failed' status. It will not be processed", entity);
            } else {
                ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Build " + build.number + ". Taking actions defined for " + branchString, entity);
                ((ActionGroupImpl)DnqUtils.getPersistentClassInstance((Entity)action, (String)"ActionGroup")).apply(build, action);
            }
        }
        this.setLastBuild(build, entity);
    }

    public void processChange(CommonChangeDTO c, Entity entity) {
        if (TeamcityBuildConfMappingImpl.eq_ad96q_a0a0i(AssociationSemantics.getToOne((Entity)entity, (String)"changesProcessingOption"), TeamcityChangesProcessingOptionImpl.DO_NOT_ATTACH.get())) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logDebug("Change " + c.version + " will be skipped due to processing rules", entity);
        } else {
            super.processChange(c, entity);
        }
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityLastChangeId", (Comparable)DateTimeArithmetics.max((Long)Long.parseLong(c.id), (Long)((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityLastChangeId", Long.class, null))), Long.class);
    }

    private void setLastBuild(CommonBuildDTO buildDto, Entity entity) {
        if (buildDto != null) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityLastBuildId", (Comparable)Long.valueOf(buildDto.id), Long.class);
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityLastBuildNumber", (Comparable)((Object)buildDto.number), String.class);
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityLastBuildAssembled", (Comparable)buildDto.start);
        } else {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityLastBuildId", (Comparable)Integer.valueOf(-1), Long.class);
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityLastBuildNumber", null, String.class);
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"teamcityLastBuildAssembled", null);
        }
    }

    protected String getLogPrefix(Entity entity) {
        return "TeamCity Integration [" + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"shortName", String.class, null) + "<-" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityProjectName", String.class, null) + ":" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityBuildTypeName", String.class, null) + "(" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"teamcityBuildTypeId", String.class, null) + ")]: ";
    }

    public String getChangeHref(CommonChangeDTO changeDto, Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"url", String.class, null) + "/viewModification.html?modId=" + changeDto.id + "&tab=vcsModificationFiles";
    }

    public CommonChangeDTO toDto(Entity change, Entity entity) {
        return new TeamcityChangeDTO(change);
    }

    public boolean canAttachChanges(Entity entity) {
        return super.canAttachChanges(entity) && TeamcityBuildConfMappingImpl.neq_ad96q_a0a0a31(AssociationSemantics.getToOne((Entity)entity, (String)"changesProcessingOption"), TeamcityChangesProcessingOptionImpl.DO_NOT_ATTACH.get());
    }

    public static Entity constructor() {
        return ((TeamcityBuildConfMappingImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Iterable<Entity> getAccessible() {
        ISetSequence accessibleProjects = SetSequence.fromSetWithValues(new HashSet(), (Iterable)((Security)ServiceLocator.getBean((String)"security")).getProjectsUnordered(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), Permission.UPDATE_PROJECT, false));
        return Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"TeamcityBuildConfMapping")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>((Set)accessibleProjects){
            final /* synthetic */ Set val$accessibleProjects;
            {
                this.val$accessibleProjects = set;
            }

            public boolean accept(Entity it) {
                return QueryOperations.contains((Iterable)this.val$accessibleProjects, (Entity)AssociationSemantics.getToOne((Entity)it, (String)"project"));
            }
        });
    }

    private static boolean neq_ad96q_a0c0c(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }

    private static boolean eq_ad96q_a0a0i(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean neq_ad96q_a0a0a31(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }
}

