/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.teamcity.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.buildServer.server.rest.data.Build;
import jetbrains.buildServer.server.rest.data.Change;
import jetbrains.buildServer.server.rest.data.Project;
import jetbrains.buildServer.server.rest.data.User;
import jetbrains.buildServer.server.rest.data.UserRef;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.teamcity.persistence.TeamcityBuildDTO;
import jetbrains.charisma.teamcity.persistence.TeamcityChangeDTO;
import jetbrains.charisma.teamcity.rest.ExistingServerTest;
import jetbrains.charisma.teamcity.rest.TeamcityRest;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.integration.build.BuildServerImpl;
import jetbrains.youtrack.integration.build.CommonBuildDTO;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.NoUserReasonImpl;
import jetbrains.youtrack.integration.vcs.VcsServerImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeFieldType;

public class TeamcityServerImpl
extends BuildServerImpl {
    private static String __ENTITY_TYPE__ = "TeamcityServer";
    public static final int MAX_TIMEOUT = 300;
    public static final boolean DISABLE_TEAMCITY_INTEGRATION = Boolean.getBoolean("jetbrains.youtrack.disableTeamcityIntegration");
    protected static Log log = LogFactory.getLog(TeamcityServerImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"socketTimeOut", (Comparable)Integer.valueOf(300), Integer.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"readTimeOut", (Comparable)Integer.valueOf(300), Integer.class);
        return entity;
    }

    protected void doProcess(final boolean async, final Iterable<Entity> cps, final Entity entity) {
        TeamcityRest.test(new ExistingServerTest(entity){

            @Override
            public void failure(String message) {
                String m = "Error while checking connection to server " + this.getUrl() + ": " + message;
                if (async) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)m);
                    }
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)m);
                }
            }

            @Override
            public void ok(TeamcityRest rest) {
                Sequence.fromIterable((Iterable)cps).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                    public void visit(Entity it) {
                        block2: {
                            try {
                                ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ChangesProcessor")).process((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Iterable<CommonChangeDTO>, Entity>(){

                                    public Iterable<CommonChangeDTO> invoke(Entity cp) {
                                        return ((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).getChanges(cp, entity);
                                    }
                                }, it);
                                DnqUtils.getCurrentTransientSession().flush();
                            }
                            catch (Throwable e) {
                                if (!log.isErrorEnabled()) break block2;
                                log.error((Object)("Error while processing Teamcity integration for project [" + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)it, (String)"project"), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) + "]"), e);
                            }
                        }
                    }
                });
            }
        }, entity, async);
    }

    private Iterable<CommonChangeDTO> getChanges(Entity changesProcessor, final Entity entity) {
        final Entity mapping = DnqUtils.cast((Object)changesProcessor, (String)"TeamcityBuildConfMapping");
        return ListSequence.fromList(((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).getRest(entity).getChangesSince((String)PrimitiveAssociationSemantics.get((Entity)mapping, (String)"teamcityProjectId", String.class, null), (Long)PrimitiveAssociationSemantics.get((Entity)mapping, (String)"teamcityLastChangeId", Long.class, null))).reversedList().select((_FunctionTypes._return_P1_E0)new ISelector<Change, CommonChangeDTO>(){

            public CommonChangeDTO select(Change it) {
                return ((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).toDto(it, mapping, entity);
            }
        }).toListSequence();
    }

    public CommonChangeDTO getChange(Iterable<Entity> processors, String version, Entity entity) {
        TeamcityRest rest = ((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).getRest(entity);
        for (Entity processor : processors) {
            Entity m = DnqUtils.cast((Object)processor, (String)"TeamcityBuildConfMapping");
            Change commit = rest.getChange((String)PrimitiveAssociationSemantics.get((Entity)m, (String)"teamcityBuildTypeId", String.class, null), version);
            if (commit == null) continue;
            return ((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).toDto(commit, m, entity);
        }
        return null;
    }

    private CommonChangeDTO toDto(Change commit, Entity m, Entity entity) {
        Tuples._2<Entity, Entity> u = ((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).resolveUser(m, commit.username, commit.user, entity);
        return new TeamcityChangeDTO(null, (Entity)u._0(), (Entity)u._1(), commit, m);
    }

    public Tuples._2<Entity, Entity> resolveUser(Entity cp, String username, UserRef userRef, Entity entity) {
        User tcUser;
        if (userRef == null) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.TEAMCITY_NO_USER_INFO_PROVIDED.get());
        }
        try {
            tcUser = ((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).getRest(entity).getUser(userRef);
            if (tcUser == null) {
                return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.TEAMCITY_NO_USER.get());
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while retrieveing user information from TeamCity", (Throwable)e);
            }
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.TEAMCITY_ERROR_RETRIEVING_USER.get());
        }
        if (TeamcityServerImpl.isEmpty_4j1vb9_a0f0g(tcUser.email)) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.TEAMCITY_NO_EMAIL_FOR_THAT_USER.get());
        }
        return ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"VcsServer")).resolveUser(tcUser.email, cp, NoUserReasonImpl.TEAMCITY_NO_USER_IN_YOUTRACK_BY_EMAIL.get(), NoUserReasonImpl.TEAMCITY_USER_IS_NOT_UNIQUE_BY_EMAIL.get(), entity);
    }

    public String getBuildHref(long buildId, Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null) + "/viewLog.html?buildId=" + buildId;
    }

    public Iterable<CommonBuildDTO> getBuilds(Entity buildsProcessor, Entity entity) {
        Entity mapping = DnqUtils.cast((Object)buildsProcessor, (String)"TeamcityBuildConfMapping");
        long since = DateTimeOperations.compare((Long)((Long)PrimitiveAssociationSemantics.get((Entity)mapping, (String)"teamcityLastBuildAssembled", null)), (CompareType)CompareType.EQ, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond()) ? (Long)PrimitiveAssociationSemantics.get((Entity)mapping, (String)"teamcityLastBuildId", Long.class, null) - 1L : (Long)PrimitiveAssociationSemantics.get((Entity)mapping, (String)"teamcityLastBuildId", Long.class, null);
        boolean successfulOnly = (Boolean)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)mapping, (String)"defaultBranchActions"), (String)"processRedBuilds", Boolean.class, null) != false || !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)mapping, (String)"featureBranchActions"), null) && (Boolean)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)mapping, (String)"featureBranchActions"), (String)"processRedBuilds", Boolean.class, null) != false;
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)mapping, (String)"ChangesProcessor")).logInfo("Requesting builds. Params: buildTypeId=" + (String)PrimitiveAssociationSemantics.get((Entity)mapping, (String)"teamcityBuildTypeId", String.class, null) + ",sinceBuildId=" + since + ",successfulOnly=" + !successfulOnly + ",defaultBranchOnly=" + EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)mapping, (String)"featureBranchActions"), null), mapping);
        return ListSequence.fromList(((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).getRest(entity).getBuildsSince((String)PrimitiveAssociationSemantics.get((Entity)mapping, (String)"teamcityBuildTypeId", String.class, null), since, !successfulOnly, EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)mapping, (String)"featureBranchActions"), null))).reversedList().select((_FunctionTypes._return_P1_E0)new ISelector<Build, CommonBuildDTO>(){

            public CommonBuildDTO select(Build it) {
                return new TeamcityBuildDTO(it);
            }
        });
    }

    public String getBuildTypeHref(String buildTypeId, Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null) + "/viewType.html?buildTypeId=" + buildTypeId;
    }

    public String getBuildTypeName(String buildTypeId, Entity entity) {
        return ((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).getRest((Entity)entity).getBuildType((String)buildTypeId).name;
    }

    public String getProjectHref(String projectId, Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null) + "/project.html?projectId=" + projectId;
    }

    public String getProjectName(String projectId, Entity entity) {
        Project p = ((TeamcityServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TeamcityServer")).getRest(entity).getProject(projectId);
        return TeamcityServerImpl.getFullName(p);
    }

    public boolean shouldResetClient(Entity entity) {
        return EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"url") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"login") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"password") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"socketTimeOut") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"readTimeOut");
    }

    public boolean isEnabled(Entity entity) {
        return !DISABLE_TEAMCITY_INTEGRATION && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"enabled", Boolean.class, null) != false;
    }

    public TeamcityRest getRest(Entity entity) {
        return TeamcityRest.createAndCheck(entity);
    }

    public static Entity constructor() {
        return ((TeamcityServerImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Entity getDefault() {
        return QueryOperations.getFirst((Iterable)QueryOperations.queryGetAll((String)"TeamcityServer"));
    }

    public static int getMaxTimeout() {
        return ConfigurationUtil.isYoutrackHosted() ? 60 : 300;
    }

    public static String getFullName(Project p) {
        String name2 = p.name;
        while ((p = p.parentProject) != null && p.parentProject != null) {
            name2 = p.name + " > " + name2;
        }
        return name2;
    }

    public static boolean isEmpty_4j1vb9_a0f0g(String str) {
        return str == null || str.length() == 0;
    }
}

