/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.teamcity.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import jetbrains.buildServer.server.rest.data.Build;
import jetbrains.buildServer.server.rest.data.BuildType;
import jetbrains.buildServer.server.rest.data.BuildTypeRef;
import jetbrains.buildServer.server.rest.data.BuildTypes;
import jetbrains.buildServer.server.rest.data.Builds;
import jetbrains.buildServer.server.rest.data.Change;
import jetbrains.buildServer.server.rest.data.Changes;
import jetbrains.buildServer.server.rest.data.IssueUsages;
import jetbrains.buildServer.server.rest.data.Project;
import jetbrains.buildServer.server.rest.data.Projects;
import jetbrains.buildServer.server.rest.data.Server;
import jetbrains.buildServer.server.rest.data.User;
import jetbrains.buildServer.server.rest.data.UserRef;
import jetbrains.buildServer.server.rest.data.VcsRoot;
import jetbrains.buildServer.server.rest.data.VcsRootEntry;
import jetbrains.charisma.rest.JacksonObjectMapperProvider;
import jetbrains.charisma.teamcity.rest.ExistingServerTest;
import jetbrains.charisma.teamcity.rest.ServerUnderTesting;
import jetbrains.charisma.teamcity.rest.TeamcityServerTest;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.ssl.SSLContextFactory;
import jetbrains.youtrack.integration.misc.ExceptionOutputUtils;
import jetbrains.youtrack.integration.misc.RestClientCache;
import jetbrains.youtrack.integration.vcs.VcsUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.joda.time.DateTimeFieldType;
import webr.framework.controller.CentralManager;

public class TeamcityRest {
    private static final int MAX_TIMEOUT = 300;
    protected static Log log = LogFactory.getLog(TeamcityRest.class);
    private WebTarget wr;
    private String auth;
    private Map<Long, Change> changesCache;
    private Map<Long, User> usersCache;
    private int majorVersion;
    private int minorVersion;

    private TeamcityRest(String teamcityUrl, String login, String password2, int socketTimeOut2, int readTimeOut2, Entity sslKey2) {
        if (socketTimeOut2 <= 0 || socketTimeOut2 > 300) {
            socketTimeOut2 = 300;
        }
        if (readTimeOut2 <= 0 || readTimeOut2 > 300) {
            readTimeOut2 = 300;
        }
        ClientBuilder builder = (ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().sslContext(((SSLContextFactory)ServiceLocator.getBean((String)"sslContextFactory")).createContext(sslKey2)).property("jersey.config.client.connectTimeout", (Object)(socketTimeOut2 * 1000))).property("jersey.config.client.readTimeout", (Object)(readTimeOut2 * 1000))).register(JacksonObjectMapperProvider.class)).register(JacksonFeature.class);
        Client c = builder.build();
        this.wr = c.target(teamcityUrl == null ? null : teamcityUrl.trim());
        this.auth = "Basic " + new String(Base64.encodeBase64((byte[])(login + ":" + password2).getBytes()));
    }

    private TeamcityRest(Entity server) {
        this((String)PrimitiveAssociationSemantics.get((Entity)server, (String)"url", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)server, (String)"login", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)server, (String)"password", String.class, null), (Integer)PrimitiveAssociationSemantics.get((Entity)server, (String)"socketTimeOut", Integer.class, null), (Integer)PrimitiveAssociationSemantics.get((Entity)server, (String)"readTimeOut", Integer.class, null), AssociationSemantics.getToOne((Entity)server, (String)"sslKey"));
    }

    @Deprecated
    protected TeamcityRest() {
    }

    private Projects getProjects() {
        return this.get(this.r("/projects"), Projects.class);
    }

    public List<Project> getProjectsList() {
        Projects projects = this.getProjects();
        return projects.projects == null ? ListSequence.fromList(new ArrayList()) : projects.projects;
    }

    public Project getProject(String projectId) {
        return this.get(this.r("/projects/" + projectId, (List<String[]>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[][]{{"fields", "name,parentProject(name,parentProject(name,parentProject(name,parentProject(name,parentProject(name)))))"}})), Project.class);
    }

    public BuildTypes getBuildTypes(String projectId) {
        return this.get(this.r("/projects/" + projectId + "/buildTypes"), BuildTypes.class);
    }

    public BuildType getBuildType(String buildTypeId) {
        return this.get(this.r("/buildTypes/" + buildTypeId), BuildType.class);
    }

    public BuildType getBuildType(BuildTypeRef buildTypeRef) {
        return this.get(this._r(buildTypeRef.href), BuildType.class);
    }

    public Builds getBuildsRefsSince(String buildTypeId, boolean successOnly, boolean defaultBranchOnly, long sinceBuildId, boolean completeObject) {
        String q = "/builds";
        IListSequence locator = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)locator).addElement((Object)"running:false");
        ListSequence.fromList((List)locator).addElement((Object)"count:100");
        ListSequence.fromList((List)locator).addElement((Object)("buildType:(id:" + buildTypeId + ")"));
        if (sinceBuildId > 0L) {
            ListSequence.fromList((List)locator).addElement((Object)("sinceBuild:(id:" + sinceBuildId + ")"));
        }
        if (successOnly) {
            ListSequence.fromList((List)locator).addElement((Object)"status:SUCCESS");
        }
        if (!defaultBranchOnly) {
            ListSequence.fromList((List)locator).addElement((Object)"branch:(default:any)");
        }
        IListSequence params = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)params).addElement((Object)new String[]{"locator", IterableUtils.join((Iterable)ListSequence.fromList((List)locator), (String)",")});
        if (completeObject) {
            ListSequence.fromList((List)params).addElement((Object)new String[]{"fields", "build(id,number,status,startDate,finishDate,relatedIssues(issueUsage),buildType(name,id),defaultBranch,branchName)"});
        }
        return this.get(this.r(q, (List<String[]>)params), Builds.class);
    }

    public Change getChange(final long changeId) {
        return this.cacheChange(changeId, (_FunctionTypes._return_P0_E0<? extends Change>)new _FunctionTypes._return_P0_E0<Change>(){

            public Change invoke() {
                return TeamcityRest.this.get(TeamcityRest.this.r("/changes/id:" + changeId), Change.class);
            }
        });
    }

    public Change getChange(final Change changeRef) {
        return this.cacheChange(changeRef.id, (_FunctionTypes._return_P0_E0<? extends Change>)new _FunctionTypes._return_P0_E0<Change>(){

            public Change invoke() {
                return TeamcityRest.this.get(TeamcityRest.this._r(changeRef.href), Change.class);
            }
        });
    }

    public Change getChange(String buildTypeId, String revisionId) {
        try {
            return this.get(this.r("/changes/buildType:(id:" + buildTypeId + "),version:" + revisionId), Change.class);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof NotFoundException) {
                return null;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("Exception when getting a TeamCity commit " + revisionId + " in build type " + buildTypeId), (Throwable)e);
            }
            return null;
        }
    }

    private Change cacheChange(long id2, _FunctionTypes._return_P0_E0<? extends Change> provider) {
        if (this.changesCache == null) {
            this.changesCache = MapSequence.fromMap(new HashMap());
        }
        if (!MapSequence.fromMap(this.changesCache).containsKey((Object)id2)) {
            MapSequence.fromMap(this.changesCache).put((Object)id2, provider.invoke());
        }
        return (Change)MapSequence.fromMap(this.changesCache).get((Object)id2);
    }

    public Set<VcsRoot> getVcsRoots(String projectId) {
        HashSet<VcsRoot> res = new HashSet<VcsRoot>();
        BuildTypes buildTypes = this.getBuildTypes(projectId);
        for (BuildTypeRef btr : buildTypes.buildTypes) {
            BuildType bt = this.getBuildType(btr);
            for (VcsRootEntry vcsRootEntry : bt.vcsRootEntries.vcsRootAssignments) {
                res.add(this.getVcsRoot(vcsRootEntry.vcsRootRef));
            }
        }
        return res;
    }

    public VcsRoot getVcsRoot(VcsRoot.VcsRootRef ref) {
        return this.get(this._r(ref.href), VcsRoot.class);
    }

    public List<Change> getChangesSince(String projectId, long sinceChange) {
        Changes changes = this.getChangesSince(sinceChange, 0L, projectId, null, this.isNotOlderThan(8, 1));
        if (changes == null) {
            return null;
        }
        if (this.isNotOlderThan(8, 1)) {
            return changes.changes;
        }
        return Sequence.fromIterable(changes.changes).select((_FunctionTypes._return_P1_E0)new ISelector<Change, Change>(){

            public Change select(Change it) {
                return TeamcityRest.this.getChange(it);
            }
        }).toListSequence();
    }

    public Changes getChangesSince(long sinceChange, long start, String projectId, String buildTypeId, boolean completeObject) {
        String q = "/changes";
        IListSequence params = ListSequence.fromList(new ArrayList());
        if (projectId != null && projectId.length() > 0) {
            ListSequence.fromList((List)params).addElement((Object)new String[]{"project", projectId});
        }
        if (buildTypeId != null && buildTypeId.length() > 0) {
            ListSequence.fromList((List)params).addElement((Object)new String[]{"buildType", buildTypeId});
        }
        ListSequence.fromList((List)params).addElement((Object)new String[]{"start", start + ""});
        ListSequence.fromList((List)params).addElement((Object)new String[]{"count", "100"});
        if (sinceChange > 0L) {
            ListSequence.fromList((List)params).addElement((Object)new String[]{"sinceChange", sinceChange + ""});
        }
        if (completeObject) {
            ListSequence.fromList((List)params).addElement((Object)new String[]{"fields", "change(id,username,version,date,comment,files,user,href)"});
        }
        return this.get(this.r(q, (List<String[]>)params), Changes.class);
    }

    public List<Build> getBuildsSince(String buildTypeId, long sinceBuildId, boolean successfulOnly, boolean defaultBranchOnly) {
        Builds builds = this.getBuildsRefsSince(buildTypeId, successfulOnly, defaultBranchOnly, sinceBuildId, this.isNotOlderThan(8, 1));
        if (builds == null) {
            return null;
        }
        if (this.isNotOlderThan(8, 1)) {
            return builds.builds;
        }
        return Sequence.fromIterable(builds.builds).select((_FunctionTypes._return_P1_E0)new ISelector<Build, Build>(){

            public Build select(Build it) {
                return TeamcityRest.this.getBuild(it.id);
            }
        }).toListSequence();
    }

    public boolean newer(Build b1, Build b2) {
        return DateTimeOperations.compare((Long)VcsUtils.toDatetime((String)b1.startDate), (CompareType)CompareType.GT, (Long)VcsUtils.toDatetime((String)b2.startDate), (DateTimeFieldType)DateTimeFieldType.millisOfSecond());
    }

    public Build getBuild(long buildId) {
        return this.populateBuild(this.get(this.r("/builds/id:" + buildId), Build.class));
    }

    private Build populateBuild(Build b) {
        if (b.relatedIssues != null && (b.relatedIssues.issueUsage == null || b.relatedIssues.issueUsage.isEmpty()) && TeamcityRest.isNotEmpty_mautgu_a0a0a81(b.relatedIssues.href)) {
            IssueUsages iU;
            b.relatedIssues = iU = this.get(this._r(b.relatedIssues.href), IssueUsages.class);
        }
        return b;
    }

    public User getUser(UserRef userRef) {
        return this.cacheUser(userRef.id);
    }

    private User cacheUser(long id2) {
        User user;
        if (this.usersCache == null) {
            this.usersCache = MapSequence.fromMap(new HashMap());
        }
        if ((user = (User)MapSequence.fromMap(this.usersCache).get((Object)id2)) == null) {
            user = this.get(this.r("/users/id:" + id2), User.class);
            MapSequence.fromMap(this.usersCache).put((Object)id2, (Object)user);
        }
        return user;
    }

    private Invocation.Builder r(String path) {
        return this.r(path, null);
    }

    private Invocation.Builder r(String path, List<String[]> params) {
        return this._r("/app/rest" + path, params);
    }

    public Server getServer() {
        Server server = this.get(this.r("/server"), Server.class);
        this.majorVersion = server.versionMajor;
        this.minorVersion = server.versionMinor;
        return server;
    }

    public boolean isNotOlderThan(int major, int minor) {
        return this.majorVersion * 100 + this.minorVersion > major * 100 + minor;
    }

    public Invocation.Builder _r(String path) {
        return this._r(path, null);
    }

    private Invocation.Builder _r(String path, List<String[]> params) {
        try {
            WebTarget _wr = this.wr.path(path);
            if (params != null) {
                for (String[] param : params) {
                    _wr = _wr.queryParam(param[0], new Object[]{param[1]});
                }
            }
            return _wr.request().header("Authorization", (Object)this.auth).header("user-agent", (Object)(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getApplicationName() + "/" + ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion() + " (build #" + ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationBuild() + "). Base URL: " + (String)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"baseUrl", String.class, null)));
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while communicating with TeamCity", (Throwable)e);
            }
            throw new LocalizedLogicException((Localization)ExceptionOutputUtils.createLocalizationObject((Exception)e));
        }
    }

    public <T> T get(Invocation.Builder builder, Class<T> c) {
        try {
            return (T)builder.get(c);
        }
        catch (WebApplicationException e) {
            throw new LocalizedLogicException((Localization)new LocalizationObject("TeamcityRest.Error_while_communicating_with_TeamCity_{0}", new Object[]{this.readEntity(e.getResponse())}), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new LocalizedLogicException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readEntity(Response r) {
        StringWriter sw = new StringWriter();
        InputStream stream = null;
        try {
            stream = (InputStream)r.getEntity();
            IOUtils.copy((InputStream)stream, (Writer)sw);
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            String string = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityRest.Can_not_read_entity_from_TeamCity_response", new Object[0]);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    protected void test(final TeamcityServerTest t, final boolean async) {
        final ServerUnderTesting serverUnderTesting = (ServerUnderTesting)ServiceLocator.getBean((String)"serverUnderTesting");
        if (async && !serverUnderTesting.getUrl().compareAndSet(null, t.getUrl())) {
            t.failure(TeamcityRest.eq_mautgu_a0a0a1a0a1a92(t.getUrl(), serverUnderTesting.getUrl().get()) ? ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityRest.Already_in_testing", new Object[0]) : ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityRest.Another_server_is_in_testing", new Object[0]));
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    TeamcityRest.checkUrl(t.getUrl());
                    TeamcityRest.this.getServer();
                    t.ok(TeamcityRest.this);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Can't connect to TeamCity Reason: ", (Throwable)e);
                    }
                    t.failure(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityRest.Can_t_connect_to_TeamCity_{reason}", new Object[]{ExceptionOutputUtils.createLocalizationObject((Exception)e).getLocalizedMessage()}));
                }
                finally {
                    if (async) {
                        serverUnderTesting.getUrl().set(null);
                    }
                }
            }
        };
        if (async) {
            ((Executor)ServiceLocator.getBean((String)"quartzThreadExecutor")).execute(runnable);
        } else {
            runnable.run();
        }
    }

    public static TeamcityRest create(Entity ts) {
        return TeamcityRest.create(ts, false);
    }

    public static TeamcityRest createAndCheck(Entity ts) {
        return TeamcityRest.create(ts, true);
    }

    private static TeamcityRest create(final Entity ts, final boolean check) {
        TeamcityRest rest = (TeamcityRest)((RestClientCache)ServiceLocator.getBean((String)"restClientCache")).get(ts, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<TeamcityRest>(){

            public TeamcityRest invoke() {
                try {
                    return new TeamcityRest(ts);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error creating a client for TeamCity REST", (Throwable)e);
                    }
                    if (check) {
                        throw new LocalizedLogicException((Localization)ExceptionOutputUtils.createLocalizationObject((Exception)e));
                    }
                    return null;
                }
            }
        });
        if (rest == null) {
            return null;
        }
        if (check) {
            rest.test(new ExistingServerTest(ts){

                @Override
                public void failure(String message) {
                    throw new LogicException(message);
                }
            }, false);
        }
        return rest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(TeamcityServerTest t) {
        boolean $nt$_mautgu_a0d = DnqUtils.getCurrentTransientSession() == null;
        TransientStoreSession ts1_mautgu_a0d = DnqUtils.beginTransientSession();
        boolean wasEx_mautgu_a0d = true;
        try {
            if (TeamcityRest.checkUrlAndCredentials(t)) {
                TeamcityRest rest;
                try {
                    rest = new TeamcityRest(t.getUrl(), t.getLogin(), t.getPassword(), t.getSocketTimeout(), t.getReadTimeout(), t.getSslKey());
                }
                catch (Exception e) {
                    t.failure(ExceptionOutputUtils.createLocalizationObject((Exception)e).getLocalizedMessage());
                    if ($nt$_mautgu_a0d && ts1_mautgu_a0d.isOpened()) {
                        if (wasEx_mautgu_a0d) {
                            ts1_mautgu_a0d.abort();
                        } else {
                            ts1_mautgu_a0d.commit();
                        }
                    }
                    return;
                }
                rest.test(t, true);
            }
            wasEx_mautgu_a0d = false;
        }
        finally {
            if ($nt$_mautgu_a0d && ts1_mautgu_a0d.isOpened()) {
                if (wasEx_mautgu_a0d) {
                    ts1_mautgu_a0d.abort();
                } else {
                    ts1_mautgu_a0d.commit();
                }
            }
        }
    }

    public static void test(TeamcityServerTest t, Entity ts, boolean async) {
        if (!t.isEnabled()) {
            t.failure(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityRest.Teamcity_integration_is_disabled_for_this_server", new Object[0]));
            return;
        }
        if (TeamcityRest.checkUrlAndCredentials(t)) {
            TeamcityRest rest = TeamcityRest.create(ts, false);
            rest.test(t, async);
        }
    }

    private static boolean checkUrlAndCredentials(TeamcityServerTest t) {
        String urlString;
        String string = urlString = TeamcityRest.isEmpty_mautgu_a0a0a0f(t.getUrl()) ? null : TeamcityRest.trim_mautgu_a0a0a0a5(t.getUrl()).toLowerCase();
        if (urlString == null || urlString.length() == 0 || EntityOperations.equals((Entity)t.getSslKey(), null) && (TeamcityRest.isEmpty_mautgu_a0a0a0a1a5(t.getLogin()) || TeamcityRest.isEmpty_mautgu_a0a0a0a1a5_0(t.getPassword()))) {
            t.failure(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityRest.URL_and_credentials_should_be_defined", new Object[0]));
            return false;
        }
        return true;
    }

    public static URL checkUrl(String urlString) throws MalformedURLException, LocalizedLogicException {
        URL url = new URL(urlString);
        if (TeamcityRest.isEmpty_mautgu_a0c0g(url.getHost())) {
            throw new LocalizedLogicException((Localization)new LocalizationObject("TeamcityRest.Host_must_be_non-empty", new Object[0]));
        }
        return url;
    }

    public static String trim_mautgu_a0a0a0a5(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean isEmpty_mautgu_a0a0a0f(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_mautgu_a0a0a0a1a5(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_mautgu_a0a0a0a1a5_0(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_mautgu_a0c0g(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty_mautgu_a0a0a81(String str) {
        return str != null && str.length() > 0;
    }

    private static boolean eq_mautgu_a0a0a1a0a1a92(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

