/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.dates.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class OffsetDateTimePrinter
implements DateTimePrinter {
    private PeriodType myPeriodType;
    private PeriodFormatter myPeriodFormatter;
    private ReadableInstant myReference;

    public OffsetDateTimePrinter(DateTime reference, DurationFieldType ... types) {
        this.myPeriodType = PeriodType.forFields((DurationFieldType[])types);
        this.myPeriodFormatter = PeriodFormat.getDefault();
        this.myReference = reference;
    }

    public OffsetDateTimePrinter(DurationFieldType ... types) {
        this((DateTime)null, types);
    }

    public int estimatePrintedLength() {
        return 10;
    }

    public void printTo(StringBuffer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
        DateTime dateTime = this.toDateTime(instant, displayOffset, displayZone);
        out.append(this.prefix(dateTime));
        this.myPeriodFormatter.printTo(out, (ReadablePeriod)this.toPeriod(dateTime));
        out.append(this.suffix(dateTime));
    }

    public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
        DateTime dateTime = this.toDateTime(instant, displayOffset, displayZone);
        out.append(this.prefix(dateTime));
        this.myPeriodFormatter.printTo(out, (ReadablePeriod)this.toPeriod(dateTime));
        out.append(this.suffix(dateTime));
    }

    public void printTo(StringBuffer out, ReadablePartial partial, Locale locale) {
        DateTime dateTime = this.toDateTime(partial);
        out.append(this.prefix(dateTime));
        this.myPeriodFormatter.printTo(out, (ReadablePeriod)this.toPeriod(dateTime));
        out.append(this.suffix(dateTime));
    }

    public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
        DateTime dateTime = this.toDateTime(partial);
        out.append(this.prefix(dateTime));
        this.myPeriodFormatter.printTo(out, (ReadablePeriod)this.toPeriod(dateTime));
        out.append(this.suffix(dateTime));
    }

    private DateTime toDateTime(long instant, int displayOffset, DateTimeZone displayZone) {
        DateTime dateTime = new DateTime(instant - (long)displayOffset, displayZone);
        return dateTime;
    }

    private DateTime toDateTime(ReadablePartial partial) {
        DateTime dateTime = new DateTime((Object)partial);
        return dateTime;
    }

    private Period toPeriod(DateTime dateTime) {
        boolean isBefore = this.myReference == null ? dateTime.isBeforeNow() : dateTime.compareTo(this.myReference) < 0;
        Period period = isBefore ? new Period((ReadableInstant)dateTime, this.myReference, this.myPeriodType) : new Period(this.myReference, (ReadableInstant)dateTime, this.myPeriodType);
        return period;
    }

    private String prefix(DateTime dateTime) {
        boolean isBefore = this.myReference == null ? dateTime.isBeforeNow() : dateTime.compareTo(this.myReference) < 0;
        return isBefore ? "" : "in ";
    }

    private String suffix(DateTime dateTime) {
        boolean isBefore = this.myReference == null ? dateTime.isBeforeNow() : dateTime.compareTo(this.myReference) < 0;
        return isBefore ? " ago" : "";
    }
}

