/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.database.exceptions;

import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.EntityFieldHandler;
import jetbrains.exodus.entitystore.EntityId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/database/exceptions/SimplePropertyValidationException;", "Ljetbrains/exodus/database/exceptions/DataIntegrityViolationException;", "message", "", "displayMessage", "entity", "Ljetbrains/exodus/database/TransientEntity;", "propertyName", "(Ljava/lang/String;Ljava/lang/String;Ljetbrains/exodus/database/TransientEntity;Ljava/lang/String;)V", "entityFieldHandler", "Ljetbrains/exodus/database/exceptions/EntityFieldHandler;", "getEntityFieldHandler", "()Ljetbrains/exodus/database/exceptions/EntityFieldHandler;", "getPropertyName", "()Ljava/lang/String;", "relatesTo", "", "fieldIdentity", "", "dnq-open-api"})
public class SimplePropertyValidationException
extends DataIntegrityViolationException {
    @NotNull
    private final EntityFieldHandler entityFieldHandler;
    @NotNull
    private final String propertyName;

    @Override
    @NotNull
    public EntityFieldHandler getEntityFieldHandler() {
        return this.entityFieldHandler;
    }

    @Override
    public boolean relatesTo(@NotNull TransientEntity entity, @Nullable Object fieldIdentity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return super.relatesTo(entity, fieldIdentity) && Intrinsics.areEqual((Object)this.propertyName, (Object)fieldIdentity);
    }

    @NotNull
    public final String getPropertyName() {
        return this.propertyName;
    }

    public SimplePropertyValidationException(@NotNull String message, @NotNull String displayMessage, @NotNull TransientEntity entity, @NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)displayMessage, (String)"displayMessage");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        super(message, displayMessage, entity);
        this.propertyName = propertyName;
        EntityId entityId = entity.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"entity.id");
        this.entityFieldHandler = new EntityFieldHandler(entityId, this.propertyName);
    }
}

