/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.database.exceptions;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.EntityFieldHandler;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.metadata.Index;
import jetbrains.exodus.query.metadata.IndexField;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/database/exceptions/UniqueIndexIntegrityException;", "Ljetbrains/exodus/database/exceptions/DataIntegrityViolationException;", "entity", "Ljetbrains/exodus/database/TransientEntity;", "index", "Ljetbrains/exodus/query/metadata/Index;", "cause", "", "(Ljetbrains/exodus/database/TransientEntity;Ljetbrains/exodus/query/metadata/Index;Ljava/lang/Throwable;)V", "entityFieldHandler", "Ljetbrains/exodus/database/exceptions/EntityFieldHandler;", "getEntityFieldHandler", "()Ljetbrains/exodus/database/exceptions/EntityFieldHandler;", "getIndex", "()Ljetbrains/exodus/query/metadata/Index;", "relatesTo", "", "fieldIdentity", "", "dnq-open-api"})
public class UniqueIndexIntegrityException
extends DataIntegrityViolationException {
    @NotNull
    private final EntityFieldHandler entityFieldHandler;
    @NotNull
    private final Index index;

    @Override
    @NotNull
    public EntityFieldHandler getEntityFieldHandler() {
        return this.entityFieldHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean relatesTo(@NotNull TransientEntity entity, @Nullable Object fieldIdentity) {
        IndexField indexField;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (!super.relatesTo(entity, fieldIdentity)) return false;
        if (fieldIdentity == null) return true;
        List list = this.index.getFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"index.fields");
        Iterable $receiver$iv = list;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $receiver$iv.iterator();
        do {
            IndexField it;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            indexField = it = (IndexField)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)indexField, (String)"it");
        } while (!Intrinsics.areEqual((Object)indexField.getName(), (Object)fieldIdentity));
        return true;
    }

    @NotNull
    public final Index getIndex() {
        return this.index;
    }

    public UniqueIndexIntegrityException(@NotNull TransientEntity entity, @NotNull Index index, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        super("Index [" + index + "] is corrupted", null, entity, cause, 2, null);
        this.index = index;
        EntityId entityId = entity.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"entity.id");
        List list = this.index.getFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"index.fields");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"index.fields.first()");
        String string = ((IndexField)object).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"index.fields.first().name");
        this.entityFieldHandler = new EntityFieldHandler(entityId, string);
    }
}

