/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.LocalContext;
import freemarker.core.MessageUtil;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.core.TextBlock;
import freemarker.core._CoreStringUtils;
import freemarker.core._DelayedJQuote;
import freemarker.core._ErrorDescriptionBuilder;
import freemarker.core._MiscTemplateException;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class Macro
extends TemplateElement
implements TemplateModel {
    static final Macro DO_NOTHING_MACRO = new Macro(".pass", Collections.EMPTY_LIST, Collections.EMPTY_MAP, null, false, TextBlock.EMPTY_BLOCK);
    static final int TYPE_MACRO = 0;
    static final int TYPE_FUNCTION = 1;
    private final String name;
    private final String[] paramNames;
    private final Map paramDefaults;
    private final String catchAllParamName;
    private final boolean function;

    Macro(String name, List argumentNames, Map args, String catchAllParamName, boolean function, TemplateElement nestedBlock) {
        this.name = name;
        this.paramNames = argumentNames.toArray(new String[argumentNames.size()]);
        this.paramDefaults = args;
        this.function = function;
        this.catchAllParamName = catchAllParamName;
        this.setNestedBlock(nestedBlock);
    }

    public String getCatchAll() {
        return this.catchAllParamName;
    }

    public String[] getArgumentNames() {
        return (String[])this.paramNames.clone();
    }

    String[] getArgumentNamesInternal() {
        return this.paramNames;
    }

    boolean hasArgNamed(String name) {
        return this.paramDefaults.containsKey(name);
    }

    public String getName() {
        return this.name;
    }

    void accept(Environment env) {
        env.visitMacroDef(this);
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        sb.append(' ');
        sb.append(_CoreStringUtils.toFTLTopLevelTragetIdentifier(this.name));
        if (this.function) {
            sb.append('(');
        }
        int argCnt = this.paramNames.length;
        for (int i = 0; i < argCnt; ++i) {
            if (this.function) {
                if (i != 0) {
                    sb.append(", ");
                }
            } else {
                sb.append(' ');
            }
            String argName = this.paramNames[i];
            sb.append(_CoreStringUtils.toFTLTopLevelIdentifierReference(argName));
            if (this.paramDefaults == null || this.paramDefaults.get(argName) == null) continue;
            sb.append('=');
            Expression defaultExpr = (Expression)this.paramDefaults.get(argName);
            if (this.function) {
                sb.append(defaultExpr.getCanonicalForm());
                continue;
            }
            MessageUtil.appendExpressionAsUntearable(sb, defaultExpr);
        }
        if (this.catchAllParamName != null) {
            if (this.function) {
                if (argCnt != 0) {
                    sb.append(", ");
                }
            } else {
                sb.append(' ');
            }
            sb.append(this.catchAllParamName);
            sb.append("...");
        }
        if (this.function) {
            sb.append(')');
        }
        if (canonical) {
            sb.append('>');
            if (this.getNestedBlock() != null) {
                sb.append(this.getNestedBlock().getCanonicalForm());
            }
            sb.append("</").append(this.getNodeTypeSymbol()).append('>');
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return this.function ? "#function" : "#macro";
    }

    boolean isShownInStackTrace() {
        return false;
    }

    public boolean isFunction() {
        return this.function;
    }

    int getParameterCount() {
        return 1 + this.paramNames.length * 2 + 1 + 1;
    }

    Object getParameterValue(int idx) {
        if (idx == 0) {
            return this.name;
        }
        int argDescsEnd = this.paramNames.length * 2 + 1;
        if (idx < argDescsEnd) {
            String paramName = this.paramNames[(idx - 1) / 2];
            if (idx % 2 != 0) {
                return paramName;
            }
            return this.paramDefaults.get(paramName);
        }
        if (idx == argDescsEnd) {
            return this.catchAllParamName;
        }
        if (idx == argDescsEnd + 1) {
            return new Integer(this.function ? 1 : 0);
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        if (idx == 0) {
            return ParameterRole.ASSIGNMENT_TARGET;
        }
        int argDescsEnd = this.paramNames.length * 2 + 1;
        if (idx < argDescsEnd) {
            if (idx % 2 != 0) {
                return ParameterRole.PARAMETER_NAME;
            }
            return ParameterRole.PARAMETER_DEFAULT;
        }
        if (idx == argDescsEnd) {
            return ParameterRole.CATCH_ALL_PARAMETER_NAME;
        }
        if (idx == argDescsEnd + 1) {
            return ParameterRole.AST_NODE_SUBTYPE;
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return true;
    }

    class Context
    implements LocalContext {
        final Environment.Namespace localVars;
        final TemplateElement nestedContent;
        final Environment.Namespace nestedContentNamespace;
        final List nestedContentParameterNames;
        final ArrayList prevLocalContextStack;
        final Context prevMacroContext;

        Context(Environment env, TemplateElement nestedContent, List nestedContentParameterNames) {
            this.localVars = env.new Environment.Namespace();
            this.nestedContent = nestedContent;
            this.nestedContentNamespace = env.getCurrentNamespace();
            this.nestedContentParameterNames = nestedContentParameterNames;
            this.prevLocalContextStack = env.getLocalContextStack();
            this.prevMacroContext = env.getCurrentMacroContext();
        }

        Macro getMacro() {
            return Macro.this;
        }

        void runMacro(Environment env) throws TemplateException, IOException {
            this.sanityCheck(env);
            if (Macro.this.getNestedBlock() != null) {
                env.visit(Macro.this.getNestedBlock());
            }
        }

        void sanityCheck(Environment env) throws TemplateException {
            InvalidReferenceException firstReferenceException;
            Expression firstUnresolvedExpression;
            boolean hasUnresolvedArg;
            boolean resolvedAnArg;
            do {
                firstUnresolvedExpression = null;
                firstReferenceException = null;
                hasUnresolvedArg = false;
                resolvedAnArg = false;
                for (int i = 0; i < Macro.this.paramNames.length; ++i) {
                    Object[] objectArray;
                    String argName = Macro.this.paramNames[i];
                    if (this.localVars.get(argName) != null) continue;
                    Expression valueExp = (Expression)Macro.this.paramDefaults.get(argName);
                    if (valueExp != null) {
                        try {
                            TemplateModel tm = valueExp.eval(env);
                            if (tm == null) {
                                if (hasUnresolvedArg) continue;
                                firstUnresolvedExpression = valueExp;
                                hasUnresolvedArg = true;
                                continue;
                            }
                            this.localVars.put(argName, tm);
                            resolvedAnArg = true;
                        }
                        catch (InvalidReferenceException e) {
                            if (hasUnresolvedArg) continue;
                            hasUnresolvedArg = true;
                            firstReferenceException = e;
                        }
                        continue;
                    }
                    if (env.isClassicCompatible()) continue;
                    boolean argWasSpecified = this.localVars.containsKey(argName);
                    _ErrorDescriptionBuilder _ErrorDescriptionBuilder2 = new _ErrorDescriptionBuilder(new Object[]{"When calling macro ", new _DelayedJQuote(Macro.this.name), ", required parameter ", new _DelayedJQuote(argName), " (parameter #", new Integer(i + 1), ") was ", argWasSpecified ? "specified, but had null/missing value." : "not specified."});
                    if (argWasSpecified) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = "If the parameter value expression on the caller side is known to be legally null/missing, you may want to specify a default value for it with the \"!\" operator, like paramValue!defaultValue.";
                    } else {
                        Object[] objectArray3 = new Object[3];
                        objectArray3[0] = "If the omission was deliberate, you may consider making the parameter optional in the macro by specifying a default value for it, like ";
                        objectArray3[1] = "<#macro macroName paramName=defaultExpr>";
                        objectArray = objectArray3;
                        objectArray3[2] = ")";
                    }
                    throw new _MiscTemplateException(env, _ErrorDescriptionBuilder2.tip(objectArray));
                }
            } while (resolvedAnArg && hasUnresolvedArg);
            if (hasUnresolvedArg) {
                if (firstReferenceException != null) {
                    throw firstReferenceException;
                }
                if (!env.isClassicCompatible()) {
                    throw InvalidReferenceException.getInstance(firstUnresolvedExpression, env);
                }
            }
        }

        public TemplateModel getLocalVariable(String name) throws TemplateModelException {
            return this.localVars.get(name);
        }

        Environment.Namespace getLocals() {
            return this.localVars;
        }

        void setLocalVar(String name, TemplateModel var) {
            this.localVars.put(name, var);
        }

        public Collection getLocalVariableNames() throws TemplateModelException {
            HashSet<String> result = new HashSet<String>();
            TemplateModelIterator it = this.localVars.keys().iterator();
            while (it.hasNext()) {
                result.add(it.next().toString());
            }
            return result;
        }
    }
}

