/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.gap.resource.pojo;

import com.fasterxml.jackson.databind.ser.FilterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriInfo;
import jetbrains.gap.fields.query.FieldsQuery;
import jetbrains.gap.grammar.FieldsParser;
import jetbrains.gap.resource.WebUtilsKt;
import jetbrains.gap.resource.error.ApiError;
import jetbrains.gap.resource.pojo.GapFilteringJsonProvider;
import jetbrains.gap.resource.pojo.GapObjectGraph;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.Token;
import org.glassfish.jersey.message.filtering.spi.FilteringHelper;
import org.glassfish.jersey.message.filtering.spi.ObjectGraph;
import org.glassfish.jersey.message.filtering.spi.ObjectGraphTransformer;
import org.glassfish.jersey.message.filtering.spi.ObjectProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J3\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u001a\u001a\u00020\u0017*\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/gap/resource/pojo/GapObjectProvider;", "Lorg/glassfish/jersey/message/filtering/spi/ObjectProvider;", "Lcom/fasterxml/jackson/databind/ser/FilterProvider;", "()V", "recentFilteringGraph", "Ljetbrains/gap/resource/pojo/GapObjectGraph;", "transformer", "Lorg/glassfish/jersey/message/filtering/spi/ObjectGraphTransformer;", "uriInfo", "Ljavax/inject/Provider;", "Ljavax/ws/rs/core/UriInfo;", "createFilteringGraph", "Lorg/glassfish/jersey/message/filtering/spi/ObjectGraph;", "genericType", "Ljava/lang/reflect/Type;", "forWriter", "", "getFilteringObject", "annotations", "", "", "(Ljava/lang/reflect/Type;Z[Ljava/lang/annotation/Annotation;)Lcom/fasterxml/jackson/databind/ser/FilterProvider;", "addField", "", "fieldCtx", "Ljetbrains/gap/grammar/FieldsParser$FieldContext;", "addFields", "fieldsCtx", "Ljetbrains/gap/grammar/FieldsParser$FieldsContext;", "gap-rest"})
public final class GapObjectProvider
implements ObjectProvider<FilterProvider> {
    @Inject
    private ObjectGraphTransformer<FilterProvider> transformer;
    @Inject
    private Provider<UriInfo> uriInfo;
    private GapObjectGraph recentFilteringGraph;

    @Nullable
    public FilterProvider getFilteringObject(@NotNull Type genericType, boolean forWriter, Annotation ... annotations) {
        ObjectGraph filteringGraph;
        Intrinsics.checkParameterIsNotNull((Object)genericType, (String)"genericType");
        Intrinsics.checkParameterIsNotNull((Object)annotations, (String)"annotations");
        if (genericType instanceof Class && ApiError.class.isAssignableFrom((Class)genericType)) {
            return GapFilteringJsonProvider.Companion.getSerializeAllFilterProvider();
        }
        Class entityClass = FilteringHelper.getEntityClass((Type)genericType);
        if ((FilteringHelper.filterableEntityClass((Class)entityClass) || Map.class.isAssignableFrom(entityClass)) && (filteringGraph = this.createFilteringGraph(genericType, forWriter)) != null) {
            ObjectGraphTransformer<FilterProvider> objectGraphTransformer = this.transformer;
            if (objectGraphTransformer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"transformer");
            }
            return (FilterProvider)objectGraphTransformer.transform(filteringGraph);
        }
        return null;
    }

    private final ObjectGraph createFilteringGraph(Type genericType, boolean forWriter) {
        ObjectGraph objectGraph;
        Provider<UriInfo> provider = this.uriInfo;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uriInfo");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"uriInfo.get()");
        String query = WebUtilsKt.get((UriInfo)object, "fields");
        if (query != null) {
            GapObjectGraph gapObjectGraph;
            Class clazz = FilteringHelper.getEntityClass((Type)genericType);
            GapObjectGraph existingGraph = this.recentFilteringGraph;
            if (existingGraph != null && Intrinsics.areEqual((Object)existingGraph.getQuery(), (Object)query) && Intrinsics.areEqual(existingGraph.getEntityClass(), (Object)clazz)) {
                gapObjectGraph = existingGraph;
            } else {
                GapObjectGraph gapObjectGraph2;
                GapObjectGraph $receiver = gapObjectGraph2 = new GapObjectGraph(query, clazz);
                FieldsParser.FieldsQueryContext tree = FieldsQuery.Companion.parse(query).getTree();
                FieldsParser.FieldsContext fieldsContext = tree.fields();
                Intrinsics.checkExpressionValueIsNotNull((Object)fieldsContext, (String)"tree.fields()");
                this.addFields($receiver, fieldsContext, forWriter);
                this.recentFilteringGraph = $receiver;
                gapObjectGraph = gapObjectGraph2;
            }
            objectGraph = gapObjectGraph;
        } else {
            objectGraph = null;
        }
        return objectGraph;
    }

    private final void addFields(@NotNull GapObjectGraph $receiver, FieldsParser.FieldsContext fieldsCtx, boolean forWriter) {
        List list = fieldsCtx.f;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"fieldsCtx.f");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            FieldsParser.FieldContext it;
            FieldsParser.FieldContext fieldContext = it = (FieldsParser.FieldContext)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)fieldContext, (String)"it");
            this.addField($receiver, fieldContext, forWriter);
        }
    }

    private final void addField(@NotNull GapObjectGraph $receiver, FieldsParser.FieldContext fieldCtx, boolean forWriter) {
        Token token = fieldCtx.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)token, (String)"fieldCtx.name");
        String fieldName = token.getText();
        GapObjectGraph sub = new GapObjectGraph(null, null, 2, null);
        if (fieldCtx.fields() != null) {
            FieldsParser.FieldsContext fieldsContext = fieldCtx.fields();
            Intrinsics.checkExpressionValueIsNotNull((Object)fieldsContext, (String)"fieldCtx.fields()");
            this.addFields(sub, fieldsContext, forWriter);
            String string = fieldName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldName");
            $receiver.addSubgraph(string, sub);
        } else if (fieldCtx.field() != null) {
            FieldsParser.FieldContext fieldContext = fieldCtx.field();
            Intrinsics.checkExpressionValueIsNotNull((Object)fieldContext, (String)"fieldCtx.field()");
            this.addField(sub, fieldContext, forWriter);
            String string = fieldName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldName");
            $receiver.addSubgraph(string, sub);
        } else {
            String string = fieldName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldName");
            $receiver.addSubgraph(string, sub);
        }
    }
}

