/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.gtext.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;
import jetbrains.mps.gtext.runtime.TBaseBuilderContextListener;
import jetbrains.mps.gtext.runtime.TBuffer;
import jetbrains.mps.gtext.runtime.TContent;

public class TBaseBuilderContext {
    protected static String ROOT = "__ROOT__";
    protected Map<String, TContent> myContents;
    protected Stack<TContent> myContentsStack;
    protected TBuffer myBuffer;
    protected List<TBaseBuilderContextListener> myListeners;

    public void initBuffer(TBuffer buffer) {
        this.myContents = null;
        this.myContentsStack = null;
        TContent rootContent = new TContent(ROOT, buffer);
        this.getContents().put(ROOT, rootContent);
        rootContent.setPosition(0);
        this.getContentsStack().push(this.getContents().get(ROOT));
        this.myBuffer = buffer;
    }

    public void initBuffer() {
        this.initBuffer(new TBuffer());
    }

    public String getText() {
        if (this.getContentsStack().size() != 1) {
            throw new IllegalStateException("Can't get text, because there is open content block [" + this.getContentsStack().peek().getName() + "]");
        }
        this.notify(new ListenerVisitor(){

            @Override
            public void visit(TBaseBuilderContextListener l) {
                l.getTextCalled(TBaseBuilderContext.this);
            }
        });
        if (this.getContents().size() == 1) {
            return this.myBuffer.getText();
        }
        ArrayList<TContent> sortedContents = new ArrayList<TContent>(this.getContents().values());
        sortedContents.remove(this.getContentsStack().peek());
        Collections.sort(sortedContents, new Comparator<TContent>(){

            @Override
            public int compare(TContent o1, TContent o2) {
                return o2.getPosition() - o1.getPosition();
            }
        });
        for (TContent c : sortedContents) {
            if (c.getPosition() == -1) {
                Logger.getLogger(TBaseBuilderContext.class.getName()).info("There is no placeholder for content [" + c.getName() + "]");
                continue;
            }
            this.myBuffer.getStringBuilder().insert(c.getPosition(), c.getBuf().getText());
        }
        return this.myBuffer.getText();
    }

    public void append(String text) {
        this.myBuffer.append(text);
    }

    public void appendIndent() {
        this.myBuffer.appendIndent();
    }

    public void appendNewLine() {
        this.myBuffer.appendNewLine();
    }

    public void increaseIndent() {
        this.myBuffer.increaseIndent();
    }

    public void decreaseIndent() {
        this.myBuffer.decreaseIndent();
    }

    protected Map<String, TContent> getContents() {
        if (this.myContents == null) {
            this.myContents = new TreeMap<String, TContent>();
        }
        return this.myContents;
    }

    protected Stack<TContent> getContentsStack() {
        if (this.myContentsStack == null) {
            this.myContentsStack = new Stack();
        }
        return this.myContentsStack;
    }

    protected int getCurrentPosition() {
        return this.getContents().get(ROOT).getBuf().getCurrentPosition();
    }

    public void addContentPlaceholder(String name) {
        TContent c = this.getContentBlock(name);
        c.setPosition(this.getCurrentPosition());
    }

    public void startContentBlock(String name) {
        TContent c = this.getContentBlock(name);
        this.getContentsStack().push(c);
        this.myBuffer = c.getBuf();
    }

    private TContent getContentBlock(String name) {
        TContent content = this.getContents().get(name);
        if (content == null) {
            content = new TContent(name, new TBuffer());
            this.getContents().put(name, content);
        }
        return content;
    }

    public void endContentBlock() {
        this.getContentsStack().pop();
        this.myBuffer = this.getContentsStack().peek().getBuf();
    }

    public TContent getCurrentContent() {
        return this.getContentsStack().peek();
    }

    private List<TBaseBuilderContextListener> getListeners() {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<TBaseBuilderContextListener>();
        }
        return this.myListeners;
    }

    public void addListener(TBaseBuilderContextListener l) {
        this.getListeners().add(l);
    }

    public void removeListener(TBaseBuilderContextListener l) {
        this.getListeners().remove(l);
    }

    protected void notify(ListenerVisitor v) {
        if (this.myListeners == null) {
            return;
        }
        for (TBaseBuilderContextListener l : this.myListeners) {
            v.visit(l);
        }
    }

    protected static interface ListenerVisitor {
        public void visit(TBaseBuilderContextListener var1);
    }
}

