/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.oauth2.error.OAuthErrorCode;
import com.intellij.hub.core.Error;
import com.intellij.hub.core.URIHelper;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00060\u0001j\u0002`\u0002B!\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB)\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/hub/auth/OAuthValidationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "code", "Lcom/intellij/hub/auth/oauth2/error/OAuthErrorCode;", "description", "", "docPrefix", "(Lcom/intellij/hub/auth/oauth2/error/OAuthErrorCode;Ljava/lang/String;Ljava/lang/String;)V", "cause", "", "(Lcom/intellij/hub/auth/oauth2/error/OAuthErrorCode;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "error", "Lcom/intellij/hub/core/Error;", "getError", "()Lcom/intellij/hub/core/Error;", "com.intellij.hub.auth"})
public abstract class OAuthValidationException
extends Exception {
    @NotNull
    private final Error error;

    @NotNull
    public final Error getError() {
        return this.error;
    }

    protected OAuthValidationException(@NotNull OAuthErrorCode code, @Nullable String description, @NotNull String docPrefix) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)docPrefix, (String)"docPrefix");
        super(description);
        this.error = code.createError(description, null, URI.create(URIHelper.getHubDocsOAuthErrorURI(docPrefix, code.getAsciiCode())));
    }

    protected OAuthValidationException(@NotNull OAuthErrorCode code, @Nullable String description, @NotNull String docPrefix, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)docPrefix, (String)"docPrefix");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        super(description, cause);
        this.error = code.createError(description, null, URI.create(URIHelper.getHubDocsOAuthErrorURI(docPrefix, code.getAsciiCode())));
    }
}

