/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.token;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.oauth2.token.AccessTokenData;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010$\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020\nH\u0002J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020\u0005H\u0016J\b\u0010+\u001a\u00020\nH\u0016R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\n0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\fR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0014R\u0014\u0010 \u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\fR\u0013\u0010\"\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\f\u00a8\u0006-"}, d2={"Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "Lcom/intellij/hub/auth/AuthToken;", "data", "Lcom/intellij/hub/auth/oauth2/token/AccessTokenData;", "keyVersion", "", "signature", "", "(Lcom/intellij/hub/auth/oauth2/token/AccessTokenData;I[B)V", "client", "", "getClient", "()Ljava/lang/String;", "getData", "()Lcom/intellij/hub/auth/oauth2/token/AccessTokenData;", "expirationDate", "Ljava/util/Date;", "getExpirationDate", "()Ljava/util/Date;", "getKeyVersion", "()I", "scope", "", "getScope", "()[Ljava/lang/String;", "getSignature", "()[B", "signatureBase64", "kotlin.jvm.PlatformType", "getSignatureBase64", "ttlSeconds", "getTtlSeconds", "type", "getType", "user", "getUser", "encode", "encodeVersionAndSignature", "equals", "", "other", "", "hashCode", "toString", "Companion", "com.intellij.hub.auth"})
public class AccessToken
implements AuthToken {
    @NotNull
    private final AccessTokenData data;
    private final int keyVersion;
    @NotNull
    private final byte[] signature;
    private static final String DATA_DELIMITER = ";";
    private static final String DELIMITER = ".";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Date getExpirationDate() {
        return this.data.getExpiration();
    }

    public final int getTtlSeconds() {
        return this.data.getTtlSeconds();
    }

    @NotNull
    public final String getClient() {
        return this.data.getClient();
    }

    @NotNull
    public final String[] getScope() {
        return this.data.getScope();
    }

    @Nullable
    public final String getUser() {
        return this.data.getUser();
    }

    public final String getSignatureBase64() {
        return Base64.getEncoder().encodeToString(this.signature);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true || !(other instanceof AccessToken)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.data, (Object)((AccessToken)other).data) && Arrays.equals(this.signature, ((AccessToken)other).signature);
    }

    public int hashCode() {
        int result = this.data.hashCode();
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{data=" + this.data + ", signature=" + this.getSignatureBase64() + '}';
    }

    @Override
    @NotNull
    public String encode() {
        return this.data.encode() + ';' + this.encodeVersionAndSignature();
    }

    private final String encodeVersionAndSignature() {
        return "" + this.keyVersion + '.' + this.getSignatureBase64();
    }

    @Override
    @NotNull
    public String getType() {
        return "Bearer";
    }

    @NotNull
    public final AccessTokenData getData() {
        return this.data;
    }

    public final int getKeyVersion() {
        return this.keyVersion;
    }

    @NotNull
    public final byte[] getSignature() {
        return this.signature;
    }

    public AccessToken(@NotNull AccessTokenData data, int keyVersion, @NotNull byte[] signature) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        this.data = data;
        this.keyVersion = keyVersion;
        this.signature = signature;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/hub/auth/oauth2/token/AccessToken$Companion;", "", "()V", "DATA_DELIMITER", "", "DELIMITER", "decode", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "token", "decodeHeader", "header", "encodeHeader", "isBearer", "", "com.intellij.hub.auth"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AccessToken decode(@NotNull String token) {
            byte[] byArray;
            int n;
            void dataPart;
            List list2;
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            List parts2 = StringsKt.split$default((CharSequence)token, (String[])new String[]{AccessToken.DATA_DELIMITER}, (boolean)false, (int)0, (int)6, null);
            if (parts2.size() != 2) {
                throw (Throwable)InvalidTokenException.Companion.malformedOAuthToken();
            }
            List list3 = list2 = parts2;
            String string = (String)list3.get(0);
            list3 = list2;
            String signaturePart = (String)list3.get(1);
            AccessTokenData tokenData = AccessTokenData.Companion.decode((String)dataPart);
            List versionAndSignature = StringsKt.split$default((CharSequence)signaturePart, (String[])new String[]{AccessToken.DELIMITER}, (boolean)false, (int)0, (int)6, null);
            if (versionAndSignature.size() != 2) {
                throw (Throwable)InvalidTokenException.Companion.malformedTokenSignature();
            }
            try {
                String string2 = (String)versionAndSignature.get(0);
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException e) {
                throw (Throwable)InvalidTokenException.Companion.malformedTokenVersion(e);
            }
            int version = n;
            try {
                byArray = Base64.getDecoder().decode((String)versionAndSignature.get(1));
            }
            catch (Exception e) {
                throw (Throwable)InvalidTokenException.Companion.malformedTokenSignature(e);
            }
            byte[] signature = byArray;
            Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"signature");
            return new AccessToken(tokenData, version, signature);
        }

        @NotNull
        public final AccessToken decodeHeader(@NotNull String header2) throws InvalidTokenException {
            Intrinsics.checkParameterIsNotNull((Object)header2, (String)"header");
            if (!this.isBearer(header2)) {
                throw (Throwable)InvalidTokenException.Companion.bearerAuthHeaderTypeExpected();
            }
            String string = header2;
            int n = "Bearer ".length();
            Companion companion = Companion;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String string3 = string2;
            return companion.decode(string3);
        }

        @NotNull
        public final String encodeHeader(@NotNull AccessToken token) {
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            return "Bearer " + token.encode();
        }

        public final boolean isBearer(@Nullable String header2) {
            return header2 != null && StringsKt.startsWith$default((String)header2, (String)"Bearer ", (boolean)false, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

