/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.hub;

import javax.ws.rs.core.UriBuilder;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/client/hub/HubURLBuilder;", "", "baseUrl", "", "(Ljava/lang/String;)V", "getAvatarURL", "userId", "size", "", "getGroupURL", "groupId", "getMyUserProfileURL", "getProjectURL", "projectId", "getRoleURL", "roleId", "getServiceURL", "serviceId", "wikiMessage", "getUserProfileURL", "jetbrains.jetpass.client.accounts"})
public final class HubURLBuilder {
    private final String baseUrl;

    @NotNull
    public final String getUserProfileURL(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        return UriBuilder.fromUri((String)this.baseUrl).path("users").path("{userId}").build(new Object[]{userId}).toString();
    }

    @NotNull
    public final String getMyUserProfileURL() {
        return UriBuilder.fromUri((String)this.baseUrl).path("users").path("{userId}").build(new Object[]{"me"}).toString();
    }

    @NotNull
    public final String getGroupURL(@NotNull String groupId) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        return UriBuilder.fromUri((String)this.baseUrl).path("groups").path("{groupId}").build(new Object[]{groupId}).toString();
    }

    @NotNull
    public final String getServiceURL(@NotNull String serviceId, @Nullable String wikiMessage) {
        UriBuilder uriBuilder;
        Intrinsics.checkParameterIsNotNull((Object)serviceId, (String)"serviceId");
        UriBuilder it = uriBuilder = UriBuilder.fromUri((String)this.baseUrl).path("services").path("{serviceId}");
        return (wikiMessage != null ? it.queryParam("wikiMessage", new Object[]{wikiMessage}) : it).build(new Object[]{serviceId}).toString();
    }

    @NotNull
    public final String getProjectURL(@NotNull String projectId) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        return UriBuilder.fromUri((String)this.baseUrl).path("projects").path("{projectId}").build(new Object[]{projectId}).toString();
    }

    @NotNull
    public final String getRoleURL(@NotNull String roleId) {
        Intrinsics.checkParameterIsNotNull((Object)roleId, (String)"roleId");
        return UriBuilder.fromUri((String)this.baseUrl).path("roles").path("{roleId}").build(new Object[]{roleId}).toString();
    }

    @JvmOverloads
    @NotNull
    public final String getAvatarURL(@NotNull String userId, int size2) {
        UriBuilder uriBuilder;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        UriBuilder it = uriBuilder = UriBuilder.fromUri((String)this.baseUrl);
        it = uriBuilder = (!StringsKt.endsWith$default((String)this.baseUrl, (String)"/api/", (boolean)false, (int)2, null) ? it.path("api") : it).path("rest").path("avatar").path("{userId}");
        return (size2 > 0 ? it.queryParam("s", new Object[]{size2}) : it).build(new Object[]{userId}).toString();
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ String getAvatarURL$default(HubURLBuilder hubURLBuilder, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return hubURLBuilder.getAvatarURL(string, n);
    }

    @JvmOverloads
    @NotNull
    public final String getAvatarURL(@NotNull String userId) {
        return HubURLBuilder.getAvatarURL$default(this, userId, 0, 2, null);
    }

    public HubURLBuilder(@NotNull String baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        this.baseUrl = StringsKt.endsWith$default((String)baseUrl, (String)"/", (boolean)false, (int)2, null) ? baseUrl : baseUrl + "/";
    }
}

