/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.api;

import jetbrains.jetpass.dao.api.DataAccessException;

public class FieldException
extends DataAccessException {
    private String field;
    private String type;

    public FieldException(String code, String type, String field) {
        super(FieldException.buildMessage(code, type, field));
        this.setCode(code);
        this.setSeverity(DataAccessException.Severity.INFO);
        this.field = field;
        this.type = type;
    }

    public FieldException(String code, String type, String field, Throwable cause) {
        super(FieldException.buildMessage(code, type, field), cause);
        this.setCode(code);
        this.setSeverity(DataAccessException.Severity.INFO);
        this.field = field;
        this.type = type;
    }

    public String getField() {
        return this.field;
    }

    public String getType() {
        return this.type;
    }

    private static String buildMessage(String shortMessage, String type, String field) {
        return "Field " + (type != null && type.length() > 0 ? type + "::" : "") + field + " " + shortMessage;
    }
}

