/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.api.permissionCache.uuid;

import java.util.Comparator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0015\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u001fJ'\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170$H\u0082\bJ\u0006\u0010%\u001a\u00020&J\u000b\u0010'\u001a\u00028\u0000\u00a2\u0006\u0002\u0010(J\u000b\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010(J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0004H\u0002R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\f\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Ljetbrains/jetpass/dao/api/permissionCache/uuid/BinaryHeap;", "E", "", "bufferSize", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(ILjava/util/Comparator;)V", "getComparator", "()Ljava/util/Comparator;", "data", "", "getData", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "<set-?>", "size", "getSize", "()I", "setSize", "(I)V", "add", "", "element", "(Ljava/lang/Object;)V", "compare", "aIndex", "bIndex", "elementAt", "index", "(I)Ljava/lang/Object;", "ifOrderIsBrokenThenSwapAnd", "parentIndex", "childIndex", "body", "Lkotlin/Function0;", "isEmpty", "", "min", "()Ljava/lang/Object;", "removeMin", "shiftDown", "nodeIndex", "shiftUp", "jetbrains.jetpass.dao"})
public final class BinaryHeap<E> {
    @NotNull
    private final Object[] data;
    private int size;
    @NotNull
    private final Comparator<E> comparator;

    @NotNull
    public final Object[] getData() {
        return this.data;
    }

    public final int getSize() {
        return this.size;
    }

    private final void setSize(int n) {
        this.size = n;
    }

    public final void add(E element) {
        if (this.size >= this.data.length) {
            throw (Throwable)new IndexOutOfBoundsException("Binary heap is full");
        }
        this.data[this.size] = element;
        int n = this.size;
        this.size = n + 1;
        int nodeIndex = this.size - 1;
        if (nodeIndex > 0) {
            this.shiftUp(nodeIndex);
        }
    }

    public final E removeMin() {
        if (this.isEmpty()) {
            throw (Throwable)new NoSuchElementException("Binary heap is empty");
        }
        E result = this.elementAt(0);
        E last = this.elementAt(this.size - 1);
        int n = this.size;
        this.size = n + -1;
        if (this.size > 0) {
            this.data[0] = last;
            this.shiftDown(0);
        }
        return result;
    }

    public final E min() {
        if (this.isEmpty()) {
            throw (Throwable)new NoSuchElementException("Binary heap is empty");
        }
        return this.elementAt(0);
    }

    public final boolean isEmpty() {
        return this.size <= 0;
    }

    private final E elementAt(int index) {
        return (E)this.data[index];
    }

    private final void shiftUp(int nodeIndex) {
        if (nodeIndex <= 0) {
            return;
        }
        BinaryHeap this_$iv = this;
        int parentIndex = (nodeIndex + 1 >> 1) - 1;
        if (this_$iv.compare(parentIndex, nodeIndex) > 0) {
            Object tmp$iv = this_$iv.getData()[parentIndex];
            this_$iv.getData()[parentIndex] = this_$iv.getData()[nodeIndex];
            this_$iv.getData()[nodeIndex] = tmp$iv;
            this.shiftUp(parentIndex);
        }
    }

    private final void shiftDown(int nodeIndex) {
        int n;
        int leftChildIndex = (nodeIndex + 1 << 1) - 1;
        int rightChildIndex = leftChildIndex + 1;
        if (rightChildIndex >= this.size) {
            if (leftChildIndex >= this.size) {
                return;
            }
            n = leftChildIndex;
        } else {
            n = this.compare(leftChildIndex, rightChildIndex) <= 0 ? leftChildIndex : rightChildIndex;
        }
        int minChildIndex = n;
        BinaryHeap this_$iv = this;
        if (this_$iv.compare(nodeIndex, minChildIndex) > 0) {
            Object tmp$iv = this_$iv.getData()[nodeIndex];
            this_$iv.getData()[nodeIndex] = this_$iv.getData()[minChildIndex];
            this_$iv.getData()[minChildIndex] = tmp$iv;
            this.shiftDown(minChildIndex);
        }
    }

    private final void ifOrderIsBrokenThenSwapAnd(int parentIndex, int childIndex, Function0<Unit> body) {
        if (this.compare(parentIndex, childIndex) > 0) {
            Object tmp = this.getData()[parentIndex];
            this.getData()[parentIndex] = this.getData()[childIndex];
            this.getData()[childIndex] = tmp;
            body.invoke();
        }
    }

    private final int compare(int aIndex, int bIndex) {
        return this.comparator.compare(this.elementAt(aIndex), this.elementAt(bIndex));
    }

    @NotNull
    public final Comparator<E> getComparator() {
        return this.comparator;
    }

    /*
     * WARNING - void declaration
     */
    public BinaryHeap(int bufferSize, @NotNull Comparator<E> comparator) {
        void var3_4;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        this.comparator = comparator;
        BinaryHeap binaryHeap = this;
        Object[] result$iv = new Object[bufferSize];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            void i$iv;
            void var6_7 = i$iv;
            void var11_9 = i$iv++;
            objectArray = result$iv;
            Object var12_10 = null;
            objectArray[var11_9] = var12_10;
        }
        objectArray = var3_4;
        binaryHeap.data = objectArray;
    }
}

