/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.remote.api.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.api.security.Team;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.ProjectClient;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.security.ProjectDAO;
import jetbrains.jetpass.dao.remote.api.RemoteDAO;
import jetbrains.jetpass.dao.remote.api.RemoteNamedMutableDAO;
import jetbrains.jetpass.dao.remote.api.authority.RemoteUserDAO;
import jetbrains.jetpass.dao.remote.api.authority.RemoteUserGroupDAO;
import jetbrains.jetpass.dao.remote.api.security.RemoteProjectDAO;
import jetbrains.jetpass.dao.remote.api.util.IdRemoteRelationEnd;
import jetbrains.jetpass.dao.remote.api.util.RemoteRelationEnd;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.TeamJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.sequence.impl.ListSequence;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.Page;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008b\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001/\u0018\u00002\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u001e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0014J\u001a\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\r2\b\u0010#\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u0004H\u0014J \u0010)\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0014J(\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0014J\f\u0010,\u001a\u0006\u0012\u0002\b\u00030-H\u0016J\u0015\u0010.\u001a\u00020/2\u0006\u0010\u001a\u001a\u000200H\u0002\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u000303H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u0003032\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u0003H\u0016J\u0018\u00107\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u00108\u001a\u00020\rH\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u0018032\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010:\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016JM\u0010;\u001a\u00020\u00032\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030=2\b\u0010>\u001a\u0004\u0018\u00010\r2\b\u0010?\u001a\u0004\u0018\u00010\r2\b\u0010@\u001a\u0004\u0018\u00010\r2\b\u0010A\u001a\u0004\u0018\u0001052\b\u0010B\u001a\u0004\u0018\u00010CH\u0016\u00a2\u0006\u0002\u0010DJ\u0010\u0010E\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\rH\u0016J\u0018\u0010F\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006I"}, d2={"Ljetbrains/jetpass/dao/remote/api/security/RemoteProjectDAO;", "Ljetbrains/jetpass/dao/api/security/ProjectDAO;", "Ljetbrains/jetpass/dao/remote/api/RemoteNamedMutableDAO;", "Ljetbrains/jetpass/api/security/Project;", "Ljetbrains/jetpass/rest/dto/ProjectJSON;", "Ljetbrains/jetpass/client/accounts/Partial$Project;", "client", "Ljetbrains/jetpass/client/accounts/ProjectClient;", "(Ljetbrains/jetpass/client/accounts/ProjectClient;)V", "getClient", "()Ljetbrains/jetpass/client/accounts/ProjectClient;", "setClient", "globalProjectId", "", "teamFields", "Ljetbrains/jetpass/client/accounts/Partial;", "Ljetbrains/jetpass/client/accounts/Partial$Team;", "getTeamFields", "()Ljetbrains/jetpass/client/accounts/Partial;", "addResource", "", "projectID", "resourceID", "addTeam", "Ljetbrains/jetpass/api/security/Team;", "projectId", "team", "createPartial", "Ljetbrains/jetpass/client/FieldPartial;", "fieldName", "doCreate", "json", "partial", "doDelete", "id", "successor", "doSync", "syncStartTime", "", "doUpdate", "change", "fetchItem", "fetchPage", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "fromJSON", "jetbrains/jetpass/dao/remote/api/security/RemoteProjectDAO$fromJSON$1", "Ljetbrains/jetpass/rest/dto/TeamJSON;", "(Ljetbrains/jetpass/rest/dto/TeamJSON;)Ljetbrains/jetpass/dao/remote/api/security/RemoteProjectDAO$fromJSON$1;", "getAllItems", "Ljetbrains/jetpass/sequence/Sequence;", "withArchived", "", "getGlobal", "getTeam", "roleId", "getTeams", "getWholeTeam", "merge", "projects", "", "key", "name", "description", "archived", "owner", "Ljetbrains/jetpass/api/authority/User;", "(Ljava/lang/Iterable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljetbrains/jetpass/api/authority/User;)Ljetbrains/jetpass/api/security/Project;", "newJSON", "removeResource", "toJSON", "item", "jetbrains.jetpass.dao.remote"})
public final class RemoteProjectDAO
extends RemoteNamedMutableDAO<Project, ProjectJSON, Partial.Project>
implements ProjectDAO {
    private volatile String globalProjectId;
    @NotNull
    private ProjectClient client;

    private final Partial<Partial.Team> getTeamFields() {
        Partial<Partial.Team> partial = Partial.team(Partial.Team.ROLE(Partial.Role.ID), Partial.Team.USERS(Partial.User.ID), Partial.Team.GROUPS(Partial.UserGroup.ID));
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.team(\n          \u2026   Partial.UserGroup.ID))");
        return partial;
    }

    @Override
    @NotNull
    protected Page<ProjectJSON> fetchPage(@NotNull BaseFilter<?> filter2, @NotNull FieldPartial<Partial.Project> partial) {
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getProjectPage(filter2, partial);
    }

    @Override
    @NotNull
    public jetbrains.jetpass.sequence.Sequence<Project> getAllItems() {
        return this.getAllItems(false);
    }

    @Override
    @NotNull
    public jetbrains.jetpass.sequence.Sequence<Project> getAllItems(boolean withArchived) {
        jetbrains.jetpass.sequence.Sequence<Project> sequence;
        jetbrains.jetpass.sequence.Sequence<Project> all = sequence = super.getAllItems();
        return withArchived ? all : all.filter((Function1<Project, Boolean>)((Function1)getAllItems.1.1.INSTANCE));
    }

    @Override
    @NotNull
    public BaseFilter<?> filter() {
        return ProjectClient.Companion.filter().archived(true);
    }

    @Override
    @Nullable
    protected ProjectJSON fetchItem(@NotNull String id, @NotNull FieldPartial<Partial.Project> partial) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getProject(id, partial);
    }

    @Override
    @NotNull
    public FieldPartial<Partial.Project> createPartial(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Partial<Partial.Project> partial = Partial.project(new Partial.Project(fieldName));
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.project(Partial.Project(fieldName))");
        return partial;
    }

    @Override
    @NotNull
    protected ProjectJSON doCreate(@NotNull ProjectJSON json, @NotNull FieldPartial<Partial.Project> partial) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.createProject(json, partial);
    }

    @Override
    protected void doUpdate(@NotNull String id, @NotNull ProjectJSON change) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        this.client.updateProject(id, change);
    }

    @Override
    protected void doDelete(@NotNull String id, @Nullable String successor) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.client.deleteProject(id, successor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addResource(@NotNull String projectID, @NotNull String resourceID) throws DataAccessException {
        IdItem idItem;
        void childEnd$iv$iv;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)projectID, (String)"projectID");
        Intrinsics.checkParameterIsNotNull((Object)resourceID, (String)"resourceID");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getResourceDAO();
        IdRemoteRelationEnd idRemoteRelationEnd = new IdRemoteRelationEnd(parentDAO$iv, projectID);
        RemoteRelationEnd remoteRelationEnd = new IdRemoteRelationEnd(childDAO$iv, resourceID);
        boolean checkChildExistence$iv$iv = true;
        String parentId$iv$iv = this_$iv$iv.checkExists();
        childEnd$iv$iv.checkExists();
        Object childJSON$iv$iv = childEnd$iv$iv.toJSON();
        FieldPartial childIdPartial$iv$iv = childEnd$iv$iv.getDao().createPartial("id");
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void idPartial;
            void resourceJSON;
            FieldPartial fieldPartial = childIdPartial$iv$iv;
            ResourceJSON resourceJSON2 = (ResourceJSON)childJSON$iv$iv;
            String projectId = parentId$iv$iv;
            idItem = this.client.getResourcesClient(projectId).addResource((ResourceJSON)resourceJSON, (FieldPartial<Partial.Resource>)idPartial);
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        IdItem result$iv$iv$iv = idItem;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
        IdItem resultJSON$iv$iv = result$iv$iv$iv;
        String string = resultJSON$iv$iv.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultJSON.id");
        childEnd$iv$iv.resolve(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeResource(@NotNull String projectID, @NotNull String resourceID) throws DataAccessException {
        Unit unit;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)projectID, (String)"projectID");
        Intrinsics.checkParameterIsNotNull((Object)resourceID, (String)"resourceID");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getResourceDAO();
        IdRemoteRelationEnd idRemoteRelationEnd = new IdRemoteRelationEnd(parentDAO$iv, projectID);
        RemoteRelationEnd childEnd$iv$iv = new IdRemoteRelationEnd(childDAO$iv, resourceID);
        String parentId$iv$iv = this_$iv$iv.checkExists();
        String childId$iv$iv = childEnd$iv$iv.checkExists();
        RemoteDAO $receiver$iv$iv$iv = this_$iv$iv.getDao();
        try {
            void resourceId;
            String string = childId$iv$iv;
            String projectId = parentId$iv$iv;
            this.client.getResourcesClient(projectId).removeResource((String)resourceId);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$receiver$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        Unit result$iv$iv$iv = unit;
        $receiver$iv$iv$iv.getRemoteAPI().syncNow();
    }

    @Override
    protected void doSync(long syncStartTime) {
        this.globalProjectId = null;
        super.doSync(syncStartTime);
    }

    @Override
    @NotNull
    public Project getGlobal() {
        if (this.globalProjectId == null) {
            this.globalProjectId = this.client.global(this.getDefaultPartial()).getId();
        }
        Object i = this.getNotNull(this.globalProjectId);
        Intrinsics.checkExpressionValueIsNotNull(i, (String)"getNotNull(globalProjectId)");
        return (Project)i;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Project merge(@NotNull Iterable<? extends Project> projects, @Nullable String key, @Nullable String name, @Nullable String description, @Nullable Boolean archived, @Nullable User owner) throws DataAccessException {
        IdItem idItem;
        void $receiver$iv$iv$iv;
        Collection $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(projects, (String)"projects");
        RemoteProjectDAO $receiver$iv = this;
        Collection collection = $receiver$iv$iv = projects;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv;
            IdItem idItem2 = (IdItem)item$iv$iv$iv;
            Collection collection2 = destination$iv$iv$iv;
            Object j = $receiver$iv.toJSON(it$iv);
            collection2.add(j);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        Collection thisCollection$iv$iv = $receiver$iv$iv;
        ProjectJSON[] projectJSONArray = thisCollection$iv$iv.toArray(new ProjectJSON[0]);
        if (projectJSONArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        IdItem[] array$iv = projectJSONArray;
        FieldPartial idPartial$iv = ((RemoteDAO)$receiver$iv).createPartial("id");
        RemoteProjectDAO $receiver$iv$iv2 = $receiver$iv;
        String id$iv$iv = null;
        try {
            void idPartial;
            FieldPartial fieldPartial = idPartial$iv;
            ProjectJSON[] projectArray = (ProjectJSON[])array$iv;
            User user = owner;
            idItem = this.client.merge(key, name, description, archived, user != null ? user.getId() : null, projectArray, (FieldPartial<Partial.Project>)idPartial);
        }
        catch (WebApplicationException ex$iv$iv) {
            throw (Throwable)$receiver$iv$iv2.wrapClientException(ex$iv$iv, id$iv$iv);
        }
        IdItem result$iv$iv = idItem;
        $receiver$iv$iv2.getRemoteAPI().syncNow();
        IdItem mergedJSON$iv = result$iv$iv;
        return (Project)$receiver$iv.getNotNull(mergedJSON$iv.getId());
    }

    @Override
    @NotNull
    public jetbrains.jetpass.sequence.Sequence<Team> getTeams(@NotNull String projectId) throws DataAccessException {
        Iterable result$iv;
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        ProjectClient.TeamClient teamsClient = this.client.getTeamsClient(projectId);
        RemoteProjectDAO $receiver$iv = this;
        try {
            iterable = teamsClient.getTeamPage((BaseFilter<?>)new Filter(null, 1, null).topAll(), (FieldPartial<Partial.Team>)this.getTeamFields()).getItems();
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, projectId);
        }
        Iterable teams = result$iv = iterable;
        return new ListSequence(teams).map((Function1)new Function1<TeamJSON, fromJSON.1>(this){
            final /* synthetic */ RemoteProjectDAO this$0;

            @NotNull
            public final fromJSON.1 invoke(@NotNull TeamJSON it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return RemoteProjectDAO.access$fromJSON(this.this$0, it);
            }
            {
                this.this$0 = remoteProjectDAO;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public Team getWholeTeam(@NotNull String projectId) throws DataAccessException {
        TeamJSON result$iv;
        TeamJSON teamJSON;
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        ProjectClient.TeamClient teamsClient = this.client.getTeamsClient(projectId);
        RemoteProjectDAO $receiver$iv = this;
        try {
            teamJSON = teamsClient.whole((FieldPartial<Partial.Team>)this.getTeamFields());
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, projectId);
        }
        TeamJSON wholeTeam = result$iv = teamJSON;
        return this.fromJSON(wholeTeam);
    }

    @Override
    @NotNull
    public Team getTeam(@NotNull String projectId, @NotNull String roleId) throws DataAccessException {
        TeamJSON result$iv;
        TeamJSON teamJSON;
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)roleId, (String)"roleId");
        ProjectClient.TeamClient teamsClient = this.client.getTeamsClient(projectId);
        RemoteProjectDAO $receiver$iv = this;
        try {
            teamJSON = teamsClient.getTeam(roleId, (FieldPartial<Partial.Team>)this.getTeamFields());
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, projectId);
        }
        TeamJSON team = result$iv = teamJSON;
        return this.fromJSON(team);
    }

    @Override
    @NotNull
    public Team addTeam(@NotNull String projectId, @NotNull Team team) throws DataAccessException {
        TeamJSON teamJSON;
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)team, (String)"team");
        ProjectClient.TeamClient teamsClient = this.client.getTeamsClient(projectId);
        RemoteProjectDAO $receiver$iv = this;
        try {
            teamJSON = teamsClient.addTeam(new TeamJSON(team), (FieldPartial<Partial.Team>)this.getTeamFields());
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$receiver$iv.wrapClientException(ex$iv, projectId);
        }
        TeamJSON result$iv = teamJSON;
        $receiver$iv.getRemoteAPI().syncNow();
        TeamJSON remoteTeam = result$iv;
        return this.fromJSON(remoteTeam);
    }

    private final fromJSON.1 fromJSON(TeamJSON team) {
        return new Team(this, team){
            final /* synthetic */ RemoteProjectDAO this$0;
            final /* synthetic */ TeamJSON $team;

            @NotNull
            public Role getRole() {
                RoleJSON roleJSON = this.$team.getRole();
                I i = this.this$0.getRemoteAPI().getRoleDAO().getNotNull(roleJSON != null ? roleJSON.getId() : null);
                Intrinsics.checkExpressionValueIsNotNull(i, (String)"remoteAPI.roleDAO.getNotNull(team.role?.id)");
                return (Role)i;
            }

            @NotNull
            public Iterable<User> getUsers() {
                Sequence sequence = this.$team.getUsers();
                if (sequence == null || (sequence = CollectionsKt.asSequence(sequence)) == null) {
                    sequence = SequencesKt.emptySequence();
                }
                Sequence userSequence = sequence;
                return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)userSequence, (Function1)((Function1)new Function1<UserJSON, User>(this){
                    final /* synthetic */ fromJSON.1 this$0;

                    @NotNull
                    public final User invoke(UserJSON it) {
                        RemoteUserDAO remoteUserDAO = this.this$0.this$0.getRemoteAPI().getUserDAO();
                        UserJSON userJSON = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)userJSON, (String)"it");
                        return (User)remoteUserDAO.getNotNull(userJSON.getId());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })));
            }

            @NotNull
            public Iterable<UserGroup> getGroups() {
                Sequence sequence = this.$team.getGroups();
                if (sequence == null || (sequence = CollectionsKt.asSequence(sequence)) == null) {
                    sequence = SequencesKt.emptySequence();
                }
                Sequence groupSequence = sequence;
                return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)groupSequence, (Function1)((Function1)new Function1<UserGroupJSON, UserGroup>(this){
                    final /* synthetic */ fromJSON.1 this$0;

                    @NotNull
                    public final UserGroup invoke(UserGroupJSON it) {
                        RemoteUserGroupDAO remoteUserGroupDAO = this.this$0.this$0.getRemoteAPI().getUserGroupDAO();
                        UserGroupJSON userGroupJSON = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)userGroupJSON, (String)"it");
                        return (UserGroup)remoteUserGroupDAO.getNotNull(userGroupJSON.getId());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })));
            }

            public int getUsersTotal() {
                Integer n = this.$team.getUsersTotal();
                return n != null ? n : 0;
            }

            public int getGroupsTotal() {
                Integer n = this.$team.getGroupsTotal();
                return n != null ? n : 0;
            }
            {
                this.this$0 = $outer;
                this.$team = $captured_local_variable$1;
            }
        };
    }

    @Override
    @NotNull
    public ProjectJSON toJSON(@NotNull Project item2) {
        Intrinsics.checkParameterIsNotNull((Object)item2, (String)"item");
        return ProjectJSON.wrap(item2);
    }

    @Override
    @NotNull
    public ProjectJSON newJSON(@NotNull String id) {
        ProjectJSON projectJSON;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        ProjectJSON $receiver = projectJSON = new ProjectJSON();
        $receiver.setId(id);
        return projectJSON;
    }

    @NotNull
    public final ProjectClient getClient() {
        return this.client;
    }

    public final void setClient(@NotNull ProjectClient projectClient) {
        Intrinsics.checkParameterIsNotNull((Object)projectClient, (String)"<set-?>");
        this.client = projectClient;
    }

    public RemoteProjectDAO(@NotNull ProjectClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Partial<Partial.Project> partial = Partial.project(Partial.Project.ID, Partial.Project.ALIASES(new Partial.Alias[0]), Partial.Project.NAME);
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.project(\n       \u2026    Partial.Project.NAME)");
        super((FieldPartial)partial);
        this.client = client;
    }

    @NotNull
    public static final /* synthetic */ fromJSON.1 access$fromJSON(RemoteProjectDAO $this, @NotNull TeamJSON team) {
        return $this.fromJSON(team);
    }
}

