/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.util;

import jetbrains.jetpass.dao.util.AbstractPersistentHashSet;
import jetbrains.jetpass.dao.util.Flag;
import jetbrains.jetpass.dao.util.ObjectProcedure;

public class PersistentHashSet<K> {
    private AbstractPersistentHashSet.RootTableNode<K> root;

    public PersistentHashSet() {
        this(AbstractPersistentHashSet.EMPTY_ROOT);
    }

    public PersistentHashSet(AbstractPersistentHashSet.RootTableNode<K> root) {
        this.root = root;
    }

    public ImmutablePersistentHashSet<K> getCurrent() {
        return new ImmutablePersistentHashSet<K>(this.root);
    }

    public PersistentHashSet<K> getClone() {
        return new PersistentHashSet<K>(this.root);
    }

    public MutablePersistentHashSet<K> beginWrite() {
        return new MutablePersistentHashSet(this);
    }

    boolean endWrite(MutablePersistentHashSet<K> tree) {
        if (this.root != tree.getStartingRoot()) {
            return false;
        }
        this.root = tree.getRoot();
        return true;
    }

    AbstractPersistentHashSet.RootTableNode<K> getRoot() {
        return this.root;
    }

    public static class MutablePersistentHashSet<K>
    extends AbstractPersistentHashSet<K>
    implements Flag {
        private final PersistentHashSet<K> baseTree;
        private AbstractPersistentHashSet.RootTableNode<K> startingRoot;
        private AbstractPersistentHashSet.RootTableNode<K> root;
        private boolean flagged;

        MutablePersistentHashSet(PersistentHashSet<K> tree) {
            this.startingRoot = tree.getRoot();
            this.root = this.startingRoot;
            this.baseTree = tree;
        }

        @Override
        public boolean flag() {
            this.flagged = true;
            return true;
        }

        public void add(K key) {
            AbstractPersistentHashSet.RootTableNode<K> actualRoot = this.root;
            this.flagged = false;
            AbstractPersistentHashSet.Node<K> result = actualRoot.insert(key, key.hashCode(), 0, this);
            this.root = result.asRoot(this.flagged ? actualRoot.getSize() + 1 : actualRoot.getSize());
        }

        public boolean remove(K key) {
            AbstractPersistentHashSet.RootTableNode<K> actualRoot = this.root;
            AbstractPersistentHashSet.Node result = (AbstractPersistentHashSet.Node)actualRoot.remove(key, key.hashCode(), 0);
            if (result != null) {
                this.root = result.asRoot(actualRoot.getSize() - 1);
                return true;
            }
            return false;
        }

        public boolean endWrite() {
            if (this.baseTree.endWrite(this)) {
                this.startingRoot = this.root;
                return true;
            }
            return false;
        }

        @Override
        AbstractPersistentHashSet.RootTableNode<K> getRoot() {
            return this.root;
        }

        AbstractPersistentHashSet.TableNode<K> getStartingRoot() {
            return this.startingRoot;
        }

        public void checkTip() {
            if (this.root != null) {
                this.root.checkNode(0);
            }
        }

        public void forEachKey(ObjectProcedure<K> procedure) {
            this.root.forEachKey(procedure);
        }
    }

    public static class ImmutablePersistentHashSet<K>
    extends AbstractPersistentHashSet<K> {
        private final AbstractPersistentHashSet.RootTableNode<K> root;

        ImmutablePersistentHashSet(AbstractPersistentHashSet.RootTableNode<K> root) {
            this.root = root;
        }

        @Override
        AbstractPersistentHashSet.RootTableNode<K> getRoot() {
            return this.root;
        }
    }
}

