/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.dashboard.DashboardPermission;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.UuidJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="dashboardPermission")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=DashboardPermissionJSON.class)
public class DashboardPermissionJSON
extends UuidJSON
implements DashboardPermission {
    @XmlElement(name="permission")
    private String permission;

    public DashboardPermissionJSON() {
    }

    public DashboardPermissionJSON(@NotNull DashboardPermission that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setPermission(that.getPermission());
    }

    @Override
    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @XmlTransient
    public void setPermission(@Nullable String permission) {
        this.permission = permission;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DashboardPermission)) {
            return false;
        }
        DashboardPermission that = (DashboardPermission)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static DashboardPermissionJSON wrap(@NotNull DashboardPermission that) {
        if (that instanceof DashboardPermissionJSON) {
            return (DashboardPermissionJSON)that;
        }
        return new DashboardPermissionJSON(that);
    }
}

