/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.ImportSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="importSettings")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ImportSettingsJSON.class)
public class ImportSettingsJSON
extends SettingsJSON
implements ImportSettings {
    @XmlElement(name="importFolder")
    private String importFolder;

    public ImportSettingsJSON() {
    }

    public ImportSettingsJSON(@NotNull ImportSettings that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setImportFolder(that.getImportFolder());
    }

    @Override
    @Nullable
    public String getImportFolder() {
        return this.importFolder;
    }

    @XmlTransient
    public void setImportFolder(@Nullable String importFolder) {
        this.importFolder = importFolder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportSettings)) {
            return false;
        }
        ImportSettings that = (ImportSettings)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ImportSettingsJSON wrap(@NotNull ImportSettings that) {
        if (that instanceof ImportSettingsJSON) {
            return (ImportSettingsJSON)that;
        }
        return new ImportSettingsJSON(that);
    }
}

