/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.runtime;

import com.google.gwt.i18n.client.PluralRule;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleUtil {
    public static final Locale DEFAULT_LOCALE = Locale.US;
    protected static Log log = LogFactory.getLog(LocaleUtil.class);

    public static PluralRule getPluralRules(Locale locale) {
        block10: {
            Class<?> result;
            ClassLoader classLoader = LocaleUtil.class.getClassLoader();
            try {
                String name = "com.google.gwt.i18n.client.impl.plurals.DefaultRule_" + locale.getLanguage().toLowerCase() + "_" + locale.getCountry().toLowerCase();
                result = classLoader.loadClass(name);
            }
            catch (ClassNotFoundException ex1) {
                try {
                    String name = "com.google.gwt.i18n.client.impl.plurals.DefaultRule_" + locale.getLanguage().toLowerCase();
                    result = classLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex2) {
                    if (!locale.equals(DEFAULT_LOCALE)) {
                        return LocaleUtil.getPluralRules();
                    }
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Plural rules not found for the default locale '" + DEFAULT_LOCALE + "'."));
                    }
                    throw new RuntimeException("No plural rules class found for the default locale " + DEFAULT_LOCALE);
                }
            }
            try {
                return (PluralRule)result.newInstance();
            }
            catch (InstantiationException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can't instantiate plural rules class for locale '" + locale + "'."), (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)("Can't access plural rules class for locale '" + locale + "'."), (Throwable)e);
            }
        }
        return null;
    }

    public static PluralRule getPluralRules() {
        return LocaleUtil.getPluralRules(DEFAULT_LOCALE);
    }
}

