/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.runtime;

import com.google.gwt.i18n.client.PluralRule;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import jetbrains.exodus.util.StringHashMap;
import jetbrains.mps.baseLanguage.closures.runtime.YieldingIterator;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequenceClosure;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.DuplicateAwareProperties;
import jetbrains.mps.internationalization.runtime.LocaleUtil;
import jetbrains.mps.internationalization.runtime.LocalizationPropertyIsDuplicatedException;
import jetbrains.mps.internationalization.runtime.MessageVariants;
import jetbrains.mps.webr.stateless.template.runtime.TemplateBuilderContext;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.textBuilder.TBuilderContext;

public class Messages {
    private static String RESOURCE_EXTENSION = ".properties";
    protected static Log log = LogFactory.getLog(Messages.class);
    private StringHashMap<MessageVariants> messageVariants;
    private Locale locale;
    private PluralRule pluralRules;
    private String path;
    private List<String> reusableMessagesLists;

    public Messages(Properties properties, Locale locale) {
        this.locale = locale;
        this.messageVariants = new StringHashMap();
        this.pluralRules = LocaleUtil.getPluralRules(locale);
        this.init(locale, properties, this.messageVariants);
    }

    public Messages(List<Messages> list, Locale locale) {
        this.locale = locale;
        this.pluralRules = LocaleUtil.getPluralRules(locale);
        this.messageVariants = new StringHashMap();
        ListSequence.fromList(list).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Messages>(){

            public void visit(Messages messages) {
                Messages.this.putAllMessages(messages);
            }
        });
    }

    public Messages() {
        this.locale = LocaleUtil.DEFAULT_LOCALE;
        this.messageVariants = new StringHashMap();
        this.pluralRules = LocaleUtil.getPluralRules(this.locale);
    }

    public Messages(String path) throws IOException {
        this();
        this.path = path;
        try {
            this.init(LocaleUtil.DEFAULT_LOCALE, Messages.fillProperties(LocaleUtil.DEFAULT_LOCALE, new DuplicateAwareProperties(), path + "/messages"), this.messageVariants);
        }
        catch (LocalizationPropertyIsDuplicatedException e) {
            String resourceName = path + "/messages" + "_" + LocaleUtil.DEFAULT_LOCALE + RESOURCE_EXTENSION;
            throw new RuntimeException("Cannot load default translations from path " + resourceName, e);
        }
    }

    public void setReusableMessages(List<String> reusableMessagesLists) {
        this.reusableMessagesLists = reusableMessagesLists;
        DuplicateAwareProperties properties = new DuplicateAwareProperties();
        for (String reusableMessages : reusableMessagesLists) {
            try {
                Messages.fillProperties(LocaleUtil.DEFAULT_LOCALE, properties, reusableMessages);
            }
            catch (LocalizationPropertyIsDuplicatedException e) {
                throw new RuntimeException("Cannot load translaions for reusable messages for file " + reusableMessages, e);
            }
        }
        this.init(LocaleUtil.DEFAULT_LOCALE, properties, this.messageVariants);
    }

    public void reload() {
        StringHashMap newMessageVariants = new StringHashMap();
        if (this.path != null && this.path.length() > 0) {
            this.init(LocaleUtil.DEFAULT_LOCALE, Messages.fillProperties(LocaleUtil.DEFAULT_LOCALE, new DuplicateAwareProperties(), this.path + "/messages"), (StringHashMap<MessageVariants>)newMessageVariants);
        }
        if (ListSequence.fromList(this.reusableMessagesLists).isNotEmpty()) {
            DuplicateAwareProperties properties = new DuplicateAwareProperties();
            for (String reusableMessages : this.reusableMessagesLists) {
                try {
                    Messages.fillProperties(LocaleUtil.DEFAULT_LOCALE, properties, reusableMessages);
                }
                catch (LocalizationPropertyIsDuplicatedException e) {
                    throw new RuntimeException("Cannot load translaions for reusable messages for file " + reusableMessages, e);
                }
            }
            this.init(LocaleUtil.DEFAULT_LOCALE, properties, (StringHashMap<MessageVariants>)newMessageVariants);
        }
        this.messageVariants = newMessageVariants;
    }

    private MessageVariants getVariants(String name, StringHashMap<MessageVariants> messageVariants) {
        MessageVariants variants = (MessageVariants)messageVariants.get((Object)name);
        if (variants == null) {
            variants = new MessageVariants();
            messageVariants.put(name, (Object)variants);
        }
        return variants;
    }

    void putAllMessages(Messages messages) {
        this.messageVariants.putAll(messages.messageVariants);
    }

    public String getMessage(String id, Object ... params) {
        MessageVariants variants = (MessageVariants)this.messageVariants.get((Object)id);
        if (variants != null) {
            return variants.getMessage(this.pluralRules, params);
        }
        return null;
    }

    public boolean getMessageForTemplateContent(String id, TBuilderContext builderContext, Object ... params) {
        MessageVariants variants = (MessageVariants)this.messageVariants.get((Object)id);
        if (variants != null) {
            variants.getMessageForTemplateContent(this.pluralRules, builderContext, params);
            return true;
        }
        return false;
    }

    public boolean getMessageForStatelessTemplateContent(String id, TemplateBuilderContext builderContext, Object ... params) {
        MessageVariants variants = (MessageVariants)this.messageVariants.get((Object)id);
        if (variants != null) {
            variants.getMessageForStatelessTemplateContent(this.pluralRules, builderContext, params);
            return true;
        }
        return false;
    }

    public Iterable<String> getMissingMessages(final Messages messages) {
        return Sequence.fromClosure((_FunctionTypes._return_P0_E0)new ISequenceClosure<String>(){

            public Iterable<String> iterable() {
                return new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return new YieldingIterator<String>(){
                            private int __CP__ = 0;
                            private String _5__yield_w88nue_a0a0a0a0h;
                            private Iterator<String> _5__yield_w88nue_a0a0a0a0h_it;
                            private String _2_key;
                            private Iterator<String> _2_key_it;

                            protected boolean moveToNext() {
                                block11: while (true) {
                                    switch (this.__CP__) {
                                        case -1: {
                                            assert (false) : "Internal error";
                                            return false;
                                        }
                                        case 2: {
                                            this._2_key_it = Messages.this.messageVariants.keySet().iterator();
                                        }
                                        case 3: {
                                            if (!this._2_key_it.hasNext()) {
                                                this.__CP__ = 1;
                                                continue block11;
                                            }
                                            this._2_key = this._2_key_it.next();
                                            this.__CP__ = 4;
                                            continue block11;
                                        }
                                        case 5: {
                                            this._5__yield_w88nue_a0a0a0a0h_it = Sequence.fromIterable(((MessageVariants)Messages.this.messageVariants.get((Object)this._2_key)).getMissingMessagesInLocale(this._2_key, (MessageVariants)messages.messageVariants.get((Object)this._2_key), messages.locale)).iterator();
                                        }
                                        case 6: {
                                            if (!this._5__yield_w88nue_a0a0a0a0h_it.hasNext()) {
                                                this.__CP__ = 3;
                                                continue block11;
                                            }
                                            this._5__yield_w88nue_a0a0a0a0h = this._5__yield_w88nue_a0a0a0a0h_it.next();
                                            this.__CP__ = 7;
                                            continue block11;
                                        }
                                        case 8: {
                                            this.__CP__ = 6;
                                            this.yield(this._5__yield_w88nue_a0a0a0a0h);
                                            return true;
                                        }
                                        case 0: {
                                            this.__CP__ = 2;
                                            continue block11;
                                        }
                                        case 4: {
                                            this.__CP__ = 5;
                                            continue block11;
                                        }
                                        case 7: {
                                            this.__CP__ = 8;
                                            continue block11;
                                        }
                                    }
                                    break;
                                }
                                return false;
                            }
                        };
                    }
                };
            }
        });
    }

    private void warnDuplicate(String line) {
        if (log.isWarnEnabled()) {
            log.warn((Object)("Duplicate property line: '" + line + "' for locale '" + this.locale + "'."));
        }
    }

    private void init(Locale locale, Properties properties, StringHashMap<MessageVariants> messageVariants) throws NumberFormatException {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String line = key + "=" + value;
            boolean found = false;
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) != '[' || i != 0 && key.charAt(i - 1) == '\\') continue;
                String name = key.substring(0, i);
                MessageVariants variants = this.getVariants(name, messageVariants);
                int cb = key.indexOf(93, i);
                if (cb < 0) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Incorrect translation line '" + line + "'. No closing bracket for parameter."));
                    }
                } else if (key.length() != cb + 1) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Incorrect translation line '" + line + "'. Expected '" + key + "=<value>'."));
                    }
                } else if (key.substring(i + 1).startsWith("\\=")) {
                    Long l;
                    block18: {
                        l = null;
                        try {
                            l = new Long(key.substring(i + 3, cb));
                        }
                        catch (NumberFormatException e) {
                            if (!log.isWarnEnabled()) break block18;
                            log.warn((Object)("Incorrect translation line '" + line + "'. Expected '" + key.substring(0, i + 1) + "<integerKey>]=<value>'."), (Throwable)e);
                        }
                    }
                    if (l != null && !variants.add(l, value)) {
                        this.warnDuplicate(line);
                    }
                } else {
                    String cardinality = key.substring(i + 1, cb);
                    PluralRule.PluralForm[] pluralForms = this.pluralRules.pluralForms();
                    boolean cardinalityFound = false;
                    for (int c = 0; c < pluralForms.length; ++c) {
                        if (!cardinality.equals(pluralForms[c].getName())) continue;
                        if (!variants.add(c, value, this.pluralRules.pluralForms().length)) {
                            this.warnDuplicate(line);
                        }
                        cardinalityFound = true;
                        break;
                    }
                    if (!cardinalityFound) {
                        String plurals = "";
                        for (PluralRule.PluralForm p : pluralForms) {
                            plurals = plurals + "', '" + p.getName();
                        }
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("There is no plural identifier '" + cardinality + "' for the locale '" + locale + "'. Use one of the following: " + plurals.substring(3) + "."));
                        }
                    }
                }
                found = true;
                break;
            }
            if (found || this.getVariants(key, messageVariants).add(value)) continue;
            this.warnDuplicate(line);
        }
    }

    private static Properties fillProperties(Locale locale, Properties properties, String path) {
        block2: {
            try {
                Messages.loadProperties(path, locale, properties);
            }
            catch (IOException exception) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Could not load localization file '" + path + "'."), (Throwable)exception);
            }
        }
        return properties;
    }

    private static void loadProperties(String resourceName, Locale locale, Properties properties) throws IOException {
        Object[] resource = ServiceLocator.getResources((String)(resourceName + "_" + locale.getLanguage() + "_" + locale.getCountry() + RESOURCE_EXTENSION));
        if (!(resource != null && !Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])resource)).isEmpty() && resource[0].exists() || (resource = ServiceLocator.getResources((String)(resourceName + "_" + locale.getLanguage() + RESOURCE_EXTENSION))) != null && !Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])resource)).isEmpty())) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Cannot load properties from resource " + resourceName + "_" + locale.getLanguage() + RESOURCE_EXTENSION));
            }
            return;
        }
        properties.load(resource[0].getInputStream());
    }
}

