/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.runtime;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.DuplicateAwareProperties;
import jetbrains.mps.internationalization.runtime.LocaleEntry;
import jetbrains.mps.internationalization.runtime.LocaleUtil;
import jetbrains.mps.internationalization.runtime.LocalizationPropertyIsDuplicatedException;
import jetbrains.mps.internationalization.runtime.Messages;
import jetbrains.mps.internationalization.runtime.SupportedLocales;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class MessagesContainer
implements InitializingBean {
    private static String BUNDLE_RESOURCE_NAME_TEMPLATE = "translations/%s";
    private static String MESSAGES_PATTERN = "translations/**/*.properties";
    protected static Log log = LogFactory.getLog(MessagesContainer.class);
    private Map<Locale, Messages> _messagesMap = MapSequence.fromMap(new HashMap());
    private List<Messages> defaultMessagesList;
    private SupportedLocales localesContainer = new SupportedLocales();

    public void setMessages(List<Messages> list) throws IOException {
        this.defaultMessagesList = list;
        Messages defaultMessages = new Messages(list, LocaleUtil.DEFAULT_LOCALE);
        MapSequence.fromMap(this._messagesMap).put((Object)LocaleUtil.DEFAULT_LOCALE, (Object)defaultMessages);
        if (log.isInfoEnabled()) {
            log.info((Object)"Default locale messages loaded");
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.loadSupportedLocalesMessagesToMap(this._messagesMap);
    }

    public void loadSupportedLocalesMessagesToMap(Map<Locale, Messages> messagesMap) throws IOException {
        Object[] resources;
        try {
            resources = ServiceLocator.getResources((String)MESSAGES_PATTERN);
        }
        catch (IOException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Failed to load translations. No translation will be used in application");
            }
            resources = new Resource[]{};
        }
        ISequence messagesResources = Sequence.fromArray((Object[])resources);
        ArrayList legacyFileLocales = new ArrayList();
        for (LocaleEntry localeEntry : Sequence.fromIterable(this.localesContainer.getSupportedLocales())) {
            if (localeEntry.getLocale() == LocaleUtil.DEFAULT_LOCALE) continue;
            DuplicateAwareProperties localeMessages = this.loadPropertiesForLocale(localeEntry.getLocale(), (Iterable<Resource>)messagesResources);
            if (localeMessages.isEmpty()) {
                ListSequence.fromList(legacyFileLocales).addElement((Object)localeEntry);
                continue;
            }
            MapSequence.fromMap(messagesMap).put((Object)localeEntry.getLocale(), (Object)new Messages(localeMessages, localeEntry.getLocale()));
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Loaded messages for language " + localeEntry.getName()));
        }
        for (LocaleEntry pair : ListSequence.fromList(legacyFileLocales)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading custom messages for language " + pair.getName() + "..."));
            }
            DuplicateAwareProperties messagesSource = this.loadCustomMessages(pair.getLocale());
            Messages messages = (Messages)MapSequence.fromMap(messagesMap).get((Object)pair.getLocale());
            if (messages == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(pair.getName() + " is new language"));
                }
                MapSequence.fromMap(messagesMap).put((Object)pair.getLocale(), (Object)new Messages(messagesSource, pair.getLocale()));
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(pair.getName() + " overrides existing language"));
            }
            messages.putAllMessages(new Messages(messagesSource, pair.getLocale()));
        }
    }

    private DuplicateAwareProperties loadPropertiesForLocale(final Locale locale, Iterable<Resource> resources) throws UnsupportedEncodingException, IOException {
        final String resourceNamePrefix = String.format(BUNDLE_RESOURCE_NAME_TEMPLATE, locale.toString());
        DuplicateAwareProperties properties = new DuplicateAwareProperties();
        resources = Sequence.fromIterable(resources).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Resource>(){

            public boolean accept(Resource it) {
                try {
                    return it.getURL().toString().contains(resourceNamePrefix);
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Cannot load translations for locale " + locale + " from file " + it.getFilename()), (Throwable)e);
                    }
                    throw new RuntimeException(e);
                }
            }
        });
        for (Resource resource : Sequence.fromIterable((Iterable)resources)) {
            try {
                properties.load(new InputStreamReader(resource.getInputStream(), "UTF-8"));
            }
            catch (LocalizationPropertyIsDuplicatedException e) {
                throw new RuntimeException("Problems loading messages from file " + resource.getFilename() + " for locale " + locale, e);
            }
        }
        return properties;
    }

    private DuplicateAwareProperties loadCustomMessages(Locale locale) throws IOException {
        DuplicateAwareProperties customMessages = new DuplicateAwareProperties();
        File translationsDirectory = new File(this.localesContainer.getCustomLocalesLocation(), locale.toString());
        for (File messagesFile : translationsDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".properties");
            }
        })) {
            try {
                customMessages.load(new InputStreamReader((InputStream)new FileInputStream(messagesFile), "UTF-8"));
            }
            catch (LocalizationPropertyIsDuplicatedException e) {
                throw new RuntimeException("Problems loading additional translations from file " + messagesFile.getAbsoluteFile(), e);
            }
        }
        return customMessages;
    }

    public Messages getMessages(Locale locale) {
        return (Messages)MapSequence.fromMap(this._messagesMap).get((Object)locale);
    }

    void reload() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Reloading Default messages...");
        }
        ListSequence.fromList(this.defaultMessagesList).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Messages>(){

            public void visit(Messages it) {
                it.reload();
            }
        });
        Messages defaultMessages = new Messages(this.defaultMessagesList, LocaleUtil.DEFAULT_LOCALE);
        IMapSequence messagesMap = MapSequence.fromMap(new HashMap());
        MapSequence.fromMap((Map)messagesMap).put((Object)LocaleUtil.DEFAULT_LOCALE, (Object)defaultMessages);
        this.loadSupportedLocalesMessagesToMap((Map<Locale, Messages>)messagesMap);
        this._messagesMap = messagesMap;
    }

    SupportedLocales getLocales() {
        return this.localesContainer;
    }
}

