/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.parser.runtime.base;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime.YieldingIterator;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISequenceClosure;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.parser.runtime.base.LocalizedSuggestItemImpl;
import jetbrains.mps.parser.runtime.base.ParseException;
import jetbrains.mps.parser.runtime.base.StringUtils;
import jetbrains.mps.parser.runtime.base.SuggestException;
import jetbrains.mps.parser.runtime.base.SuggestItem;
import jetbrains.mps.parser.runtime.base.SuggestItemImpl;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.mps.parser.runtime.context.Symbol;
import jetbrains.mps.parser.runtime.lexer.Tokenizer;
import jetbrains.mps.parser.runtime.lexer.Word;

public abstract class BaseParser {
    private boolean debug;
    private boolean caseSensitive;

    public ASTNode parse(String input) {
        try {
            List<Word> words = Tokenizer.toWords(input, false, true);
            return this.start(words, 0, -1);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(input, e);
        }
    }

    public Iterable<SuggestItem> suggest(ASTNode node, String input, int caret) {
        try {
            List<Word> suggestWords = Tokenizer.toWords(StringUtils.substring(input, 0, caret), false, true);
            final ASTNode astNode = this.start(suggestWords, 0, caret);
            ISequence suggestItems = Sequence.fromClosure((_FunctionTypes._return_P0_E0)new ISequenceClosure<SuggestItem>(){

                public Iterable<SuggestItem> iterable() {
                    return new Iterable<SuggestItem>(){

                        @Override
                        public Iterator<SuggestItem> iterator() {
                            return new YieldingIterator<SuggestItem>(){
                                private int __CP__ = 0;
                                private Set<String> _3_usedOptions;
                                private SuggestItem _4_suggestItem;
                                private Iterator<SuggestItem> _4_suggestItem_it;
                                private String _8_option;

                                protected boolean moveToNext() {
                                    block10: while (true) {
                                        switch (this.__CP__) {
                                            case -1: {
                                                assert (false) : "Internal error";
                                                return false;
                                            }
                                            case 4: {
                                                this._4_suggestItem_it = Sequence.fromIterable((Iterable)astNode.suggestItems).iterator();
                                            }
                                            case 5: {
                                                if (!this._4_suggestItem_it.hasNext()) {
                                                    this.__CP__ = 1;
                                                    continue block10;
                                                }
                                                this._4_suggestItem = this._4_suggestItem_it.next();
                                                this.__CP__ = 6;
                                                continue block10;
                                            }
                                            case 9: {
                                                if (!SetSequence.fromSet(this._3_usedOptions).contains((Object)this._8_option)) {
                                                    this.__CP__ = 10;
                                                    continue block10;
                                                }
                                                this.__CP__ = 5;
                                                continue block10;
                                            }
                                            case 12: {
                                                this.__CP__ = 5;
                                                this.yield(this._4_suggestItem);
                                                return true;
                                            }
                                            case 0: {
                                                this._3_usedOptions = SetSequence.fromSet(new HashSet());
                                                this.__CP__ = 4;
                                                continue block10;
                                            }
                                            case 6: {
                                                this._8_option = this._4_suggestItem.getOption();
                                                this.__CP__ = 9;
                                                continue block10;
                                            }
                                            case 10: {
                                                SetSequence.fromSet(this._3_usedOptions).addElement((Object)this._8_option);
                                                this.__CP__ = 12;
                                                continue block10;
                                            }
                                        }
                                        break;
                                    }
                                    return false;
                                }
                            };
                        }
                    };
                }
            });
            if (ListSequence.fromList(suggestWords).isNotEmpty()) {
                ASTNode replaceNode = node.getReplaceNode(caret);
                final int startOffset = replaceNode != null ? replaceNode.getCharStartOffset() : caret;
                final int endOffset = Math.max(0, replaceNode != null ? replaceNode.getCharEndOffset() : caret);
                final Wrappers._int trailingSpace = new Wrappers._int(0);
                while (endOffset + trailingSpace.value < input.length() && input.charAt(endOffset + trailingSpace.value) == ' ') {
                    ++trailingSpace.value;
                }
                suggestItems = Sequence.fromIterable((Iterable)suggestItems).select((_FunctionTypes._return_P1_E0)new ISelector<SuggestItem, SuggestItem>(){

                    public SuggestItem select(SuggestItem it) {
                        if (it instanceof SuggestItemImpl) {
                            SuggestItemImpl impl = (SuggestItemImpl)it;
                            String suf = impl.getSuffix();
                            impl.setCompletionStart(Math.min(impl.getCompletionStart(), startOffset));
                            impl.setCompletionEnd(endOffset + (suf != null && suf.length() > 0 && suf.charAt(suf.length() - 1) == ' ' ? trailingSpace.value : 0));
                        }
                        return it;
                    }
                });
            }
            return suggestItems;
        }
        catch (Exception e) {
            throw new SuggestException(input, caret, e);
        }
    }

    public void setDebug(boolean value) {
        this.setDebug(value, (Set<BaseParser>)SetSequence.fromSet(new HashSet()));
    }

    private boolean setDebug(boolean value, Set<BaseParser> visitedParsers) {
        if (SetSequence.fromSet(visitedParsers).contains((Object)this)) {
            return false;
        }
        this.debug = value;
        SetSequence.fromSet(visitedParsers).addElement((Object)this);
        BaseParser[] parsers = this.getImportedParsers();
        if (parsers != null) {
            for (BaseParser parser : parsers) {
                parser.setDebug(value, visitedParsers);
            }
        }
        return true;
    }

    protected BaseParser[] getImportedParsers() {
        return null;
    }

    public boolean isDebug() {
        return this.debug;
    }

    protected void fireNonTerminalEnter(String name) {
        if (this.isDebug()) {
            System.out.printf("<%s>", name);
        }
    }

    protected void fireNonTerminalExit(String name, boolean accepted, List<Word> words, int inPosition, int consumedLength) {
        if (this.isDebug()) {
            if (accepted) {
                System.out.printf("%n</%s [%d:%d]'%s'>", name, inPosition, consumedLength, Word.toString(words, inPosition, Math.min(inPosition + consumedLength - 1, ListSequence.fromList(words).count() - 1)));
            } else {
                System.out.printf("</%s ->", name);
            }
        }
    }

    private Iterable<SuggestItem> suggestToken(List<Word> words, int inPosition, int caret, String lexem, String suggestDescription, boolean appendSpace) {
        ISequence suggestItems = null;
        if (caret >= 0) {
            String token = this.token(words, inPosition);
            if (token != null) {
                String prefix;
                int s = ((Word)ListSequence.fromList(words).getElement(inPosition)).getStartOffset();
                int e = ((Word)ListSequence.fromList(words).getElement(inPosition)).getEndOffset();
                if (s <= caret && (caret < e || appendSpace && caret == e) && lexem.startsWith(prefix = StringUtils.substring(token, 0, caret - s))) {
                    SuggestItemImpl suggestItem = this.createSuggestItem(lexem, suggestDescription, caret, s, e, appendSpace);
                    if (inPosition + 1 < ListSequence.fromList(words).count() && ((Word)ListSequence.fromList(words).getElement(inPosition + 1)).getType() == Word.Type.SPACE) {
                        suggestItem.setCompletionEnd(((Word)ListSequence.fromList(words).getElement(inPosition + 1)).getEndOffset());
                    }
                    suggestItems = Sequence.singleton((Object)suggestItem);
                }
            } else if (ListSequence.fromList(words).isNotEmpty() && ((Word)ListSequence.fromList(words).last()).getEndOffset() == caret) {
                SuggestItemImpl suggestItem = this.createSuggestItem(lexem, suggestDescription, caret, caret, caret, appendSpace);
                suggestItems = Sequence.singleton((Object)suggestItem);
            }
        }
        return suggestItems;
    }

    public void setCaseSensitive(boolean value) {
        this.caseSensitive = value;
    }

    public abstract ASTNode start(List<Word> var1, int var2, int var3);

    public String token(List<Word> words, int inPosition) {
        if (inPosition < 0 || ListSequence.fromList(words).count() <= inPosition) {
            return null;
        }
        String token = ((Word)ListSequence.fromList(words).getElement(inPosition)).getWord();
        return this.caseSensitive ? token : token.toLowerCase();
    }

    private SuggestItemImpl createSuggestItem(String option, String description, int cursor, int completionStart, int completionEnd, boolean appendSpace) {
        LocalizedSuggestItemImpl suggestItem = new LocalizedSuggestItemImpl();
        suggestItem.setOption(option);
        suggestItem.setDescription(description);
        if (appendSpace) {
            suggestItem.setSuffix(" ");
        }
        suggestItem.setMatchingStart(0);
        suggestItem.setMatchingEnd(cursor - completionStart);
        suggestItem.setCompletionStart(completionStart);
        suggestItem.setCompletionEnd(completionEnd);
        return suggestItem;
    }

    protected Symbol createTransitiveSymbol(int position) {
        return new Symbol(position, 0, true, null);
    }

    protected Symbol createTerminalSymbol(List<Word> words, int position, String token, int caret, String suggestDescription, boolean appendSuggestSpace) {
        int length = this.matchesToken(words, position, token);
        Iterable<SuggestItem> suggestItems = null;
        if (suggestDescription != null && suggestDescription.length() > 0) {
            suggestItems = this.suggestToken(words, position, caret, token, suggestDescription, appendSuggestSpace);
        }
        return new Symbol(position, length, length > 0, suggestItems);
    }

    private int matchesToken(List<Word> words, int position, String lexem) {
        String token;
        int len = 0;
        for (int i = position; i < ListSequence.fromList(words).count() && lexem.regionMatches(!this.caseSensitive, 0, token = ((Word)ListSequence.fromList(words).getElement(i)).getWord(), 0, token.length()); ++i) {
            ++len;
            lexem = StringUtils.substring(lexem, token.length());
        }
        if (lexem.length() > 0) {
            len = 0;
        }
        if (len > 0 && this.isDebug()) {
            System.out.printf("%n<token [%d:%d]'%s'/>", position, len, lexem);
        }
        return len;
    }

    protected Symbol createOptionalSymbol(int position, Symbol innerSymbol) {
        Symbol symbol = new Symbol(position, innerSymbol.accepted ? innerSymbol.length : 0, true, innerSymbol.suggestItems);
        symbol.stopSuggest = innerSymbol.stopSuggest;
        return symbol;
    }

    protected Symbol createExceptSymbol(List<Word> words, int position, String ... tokens) {
        boolean matches = this.matchesExcept(words, position, tokens);
        return new Symbol(position, matches ? 1 : 0, matches, null);
    }

    private boolean matchesExcept(List<Word> words, int inPosition, String ... tokens) {
        String t = this.token(words, inPosition);
        for (String token : tokens) {
            if (!BaseParser.eq_8v7hvc_a0a0b0s(t, token)) continue;
            return false;
        }
        if (this.isDebug()) {
            System.out.printf("%n<except [%d:1]'%s'/>", inPosition, t);
        }
        return true;
    }

    protected Symbol createEofSymbol(List<Word> words, int position) {
        return new Symbol(position, 0, this.matchesEof(words, position), null);
    }

    private boolean matchesEof(List<Word> words, int position) {
        boolean b;
        boolean bl = b = position >= ListSequence.fromList(words).count();
        if (b && this.isDebug()) {
            System.out.printf("%n<eof [%d:0]/>", position);
        }
        return b;
    }

    protected Symbol createConcatenationSymbol(int position) {
        return new Symbol(position, 0, false, null);
    }

    protected Symbol createAlternationSymbol(int position) {
        return new Symbol(position, 0, false, null);
    }

    protected Symbol createCustomSymbol(int position) {
        return new Symbol(position, 0, true, null);
    }

    private static boolean eq_8v7hvc_a0a0b0s(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

