/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.parser.runtime.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.parser.runtime.base.StyleRange;
import jetbrains.mps.parser.runtime.context.ASTType;
import jetbrains.mps.parser.runtime.context.Symbol;
import jetbrains.mps.parser.runtime.lexer.Word;

public class ASTNode
extends Symbol
implements Cloneable {
    private ASTType type;
    private String role;
    private String style;
    private boolean atom;
    private boolean closedAtom;
    private ASTNode parent;
    private List<ASTNode> children;
    private int charStartOffset;
    private int charEndOffset;

    public ASTNode(ASTType type) {
        this.type = type;
    }

    protected ASTNode clone() {
        try {
            ASTNode cloned = (ASTNode)super.clone();
            cloned.suggestItems = null;
            cloned.parent = null;
            cloned.children = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.children).count()));
            for (ASTNode child : ListSequence.fromList(this.children)) {
                ASTNode clonedChild = child.clone();
                ListSequence.fromList(cloned.children).addElement((Object)clonedChild);
                clonedChild.parent = cloned;
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends ASTNode> T copy() {
        return (T)this.clone();
    }

    public void setSymbol(List<Word> words, Symbol symbol) {
        this.position = symbol.position;
        this.length = symbol.length;
        this.suggestItems = symbol.suggestItems;
        this.accepted = symbol.accepted;
        this.stopSuggest = symbol.stopSuggest;
        this.charStartOffset = Word.getStartOffset(words, this.position);
        this.charEndOffset = Word.getStartOffset(words, this.position + this.length);
    }

    public void addChild(String role, ASTNode child) {
        if (child.accepted) {
            if (this.children == null) {
                this.children = ListSequence.fromList(new ArrayList());
            }
            if (role != null && role.length() > 0) {
                child.role = role;
            }
            ListSequence.fromList(this.children).addElement((Object)child);
            child.parent = this;
        }
    }

    public Iterable<StyleRange> getStyleRanges() {
        IListSequence styleRanges = ListSequence.fromList(new ArrayList());
        this.collectStyleRanges((List<StyleRange>)styleRanges);
        return styleRanges;
    }

    public ASTNode getReplaceNode(int caret) {
        ASTNode result;
        block3: {
            result = null;
            if (this.charStartOffset >= caret || !(this.closedAtom ? caret < this.charEndOffset : caret <= this.charEndOffset)) break block3;
            if (this.atom) {
                result = this;
            } else {
                ASTNode child;
                Iterator i$ = ListSequence.fromList(this.children).iterator();
                while (i$.hasNext() && (result = (child = (ASTNode)i$.next()).getReplaceNode(caret)) == null) {
                }
            }
        }
        return result;
    }

    public void setAtom(boolean atom, boolean closed) {
        this.atom = atom;
        this.closedAtom = closed;
    }

    public void setStyle(String value) {
        this.style = value;
    }

    public int getCharStartOffset() {
        return this.charStartOffset;
    }

    public int getCharEndOffset() {
        return this.charEndOffset;
    }

    protected void collectStyleRanges(List<StyleRange> styleRanges) {
        if (this.style != null) {
            ListSequence.fromList(styleRanges).addElement((Object)new StyleRange(this.charStartOffset, this.charEndOffset - this.charStartOffset, this.style, ""));
        } else {
            for (ASTNode child : ListSequence.fromList(this.children)) {
                child.collectStyleRanges(styleRanges);
            }
        }
    }

    public <T extends ASTNode> Iterable<T> children(ASTType ... astTypes) {
        return ListSequence.fromList(this.children).where(this.toPredicate(astTypes));
    }

    public <T extends ASTNode> Iterable<T> descendants(ASTType ... astTypes) {
        return this.descendants(this.toPredicate(astTypes));
    }

    public <T extends ASTNode> Iterable<T> descendants(_FunctionTypes._return_P1_E0<? extends Boolean, ? super ASTNode> matches) {
        IListSequence descendants = ListSequence.fromList(new ArrayList());
        IListSequence stack = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)stack).addElement((Object)this);
        while (ListSequence.fromList((List)stack).isNotEmpty()) {
            ASTNode current = (ASTNode)ListSequence.fromList((List)stack).removeLastElement();
            if (((Boolean)matches.invoke((Object)current)).booleanValue()) {
                ListSequence.fromList((List)descendants).addElement((Object)current);
            }
            ListSequence.fromList((List)stack).addSequence((ISequence)ListSequence.fromList(current.children).reversedList());
        }
        return descendants;
    }

    public boolean hasType(ASTType type) {
        return this.type.equals(type);
    }

    private _FunctionTypes._return_P1_E0<? extends Boolean, ? super ASTNode> toPredicate(final ASTType ... astTypes) {
        Object matches;
        if (astTypes == null || astTypes.length == 0) {
            matches = new _FunctionTypes._return_P1_E0<Boolean, ASTNode>(){

                public Boolean invoke(ASTNode astNode) {
                    return true;
                }
            };
        } else if (astTypes.length == 1) {
            matches = new _FunctionTypes._return_P1_E0<Boolean, ASTNode>(){

                public Boolean invoke(ASTNode astNode) {
                    return astNode.type.equals(astTypes[0]);
                }
            };
        } else {
            ISetSequence matchTypes = SetSequence.fromSetWithValues(new HashSet(), (Iterable)Sequence.fromArray((Object[])astTypes));
            matches = new _FunctionTypes._return_P1_E0<Boolean, ASTNode>((Set)matchTypes){
                final /* synthetic */ Set val$matchTypes;
                {
                    this.val$matchTypes = set;
                }

                public Boolean invoke(ASTNode astNode) {
                    return SetSequence.fromSet((Set)this.val$matchTypes).contains((Object)astNode.type);
                }
            };
        }
        return matches;
    }

    public String toString() {
        return this.type.getName() + ":" + this.getClass().getSimpleName();
    }

    public static <T extends ASTNode> Iterable<T> getChildren(ASTNode node, final String role) {
        if (node == null) {
            return null;
        }
        return ListSequence.fromList(node.children).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return role.equals(it.role);
            }
        });
    }

    public static <T extends ASTNode> Iterable<T> getChildren(Iterable<? extends ASTNode> nodes, final String role) {
        return Sequence.fromIterable(nodes).translate((_FunctionTypes._return_P1_E0)new ITranslator2<ASTNode, T>(){

            public Iterable<T> translate(ASTNode it) {
                return ASTNode.getChildren(it, role);
            }
        });
    }

    public static <T extends ASTNode> T addChild(ASTNode parentNode, String role, T childNode) {
        childNode.accepted = true;
        parentNode.addChild(role, childNode);
        return childNode;
    }

    public static <T extends ASTNode> T addChild(Iterable<? extends ASTNode> parentNode, String role, T childNode) {
        return ASTNode.addChild((ASTNode)Sequence.fromIterable(parentNode).last(), role, childNode);
    }

    public static <T extends ASTNode> T getParent(ASTNode childNode) {
        if (childNode == null) {
            return null;
        }
        return (T)childNode.parent;
    }

    public static void delete(ASTNode node) {
        if (node.parent != null) {
            ListSequence.fromList(node.parent.children).removeElement((Object)node);
            node.parent = null;
        }
    }

    public static void delete(Iterable<? extends ASTNode> nodes) {
        Sequence.fromIterable(nodes).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ASTNode>(){

            public void visit(ASTNode it) {
                ASTNode.delete(it);
            }
        });
    }
}

