/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.parser.runtime.lexer;

import jetbrains.mps.parser.runtime.lexer.CharIterable;
import jetbrains.mps.parser.runtime.lexer.CharIterator;
import org.jetbrains.annotations.NotNull;

public class CharSequenceIterable
implements CharIterable {
    private final CharSequence sequence;

    public CharSequenceIterable(@NotNull CharSequence charSequence) {
        this.sequence = charSequence;
    }

    @Override
    public CharIterator iterator() {
        return new Iterator();
    }

    @Override
    public CharIterator reverseIterator() {
        return new ReverseIterator();
    }

    @Override
    public String toString() {
        return new StringBuilder(this.sequence).toString();
    }

    private class ReverseIterator
    implements CharIterator {
        private int nextPosition;

        public ReverseIterator() {
            this.nextPosition = CharSequenceIterable.this.sequence.length() - 1;
        }

        @Override
        public char next() {
            return CharSequenceIterable.this.sequence.charAt(this.nextPosition--);
        }

        @Override
        public boolean hasNext() {
            return this.nextPosition >= 0;
        }
    }

    private class Iterator
    implements CharIterator {
        private int nextPosition = 0;

        @Override
        public char next() {
            return CharSequenceIterable.this.sequence.charAt(this.nextPosition++);
        }

        @Override
        public boolean hasNext() {
            return this.nextPosition < CharSequenceIterable.this.sequence.length();
        }
    }
}

