/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.parser.runtime.lexer;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.parser.runtime.lexer.Lexer;
import jetbrains.mps.parser.runtime.lexer.LexerListener;
import jetbrains.mps.parser.runtime.lexer.Word;

public class Tokenizer
implements LexerListener {
    private List<Word> result = ListSequence.fromList(new ArrayList());

    private Tokenizer() {
    }

    @Override
    public void token(String token, int startOffset, int endOffset) {
        ListSequence.fromList(this.result).addElement((Object)new Word(Word.Type.TOKEN, token, startOffset, endOffset));
    }

    @Override
    public void space(int startOffset, int endOffset) {
        ListSequence.fromList(this.result).addElement((Object)new Word(Word.Type.SPACE, " ", startOffset, endOffset));
    }

    @Override
    public void punctuation(String token, int startOffset, int endOffset) {
        ListSequence.fromList(this.result).addElement((Object)new Word(Word.Type.PUNCTUATION, token, startOffset, endOffset));
    }

    @Override
    public void eol(int length) {
    }

    public static List<Word> toWordsIgnorePunctuation(String s) {
        Tokenizer tokenizer = new Tokenizer();
        Lexer l = new Lexer(s == null ? null : s.trim(), tokenizer);
        l.parseIgnorePunctuation();
        return tokenizer.result;
    }

    public static List<Word> toWords(String s) {
        return Tokenizer.toWords(s, false, false);
    }

    public static List<Word> toWords(String s, boolean trim, boolean lineBreakAsSpace) {
        Tokenizer tokenizer = new Tokenizer();
        Lexer l = new Lexer((String)(trim ? (s == null ? null : s.trim()) : s), tokenizer);
        l.setLineBreakAsSpace(lineBreakAsSpace);
        l.parse();
        return tokenizer.result;
    }
}

