/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.parser.runtime.lexer;

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.parser.runtime.lexer.StringUtils;

public class Word {
    private Type type;
    private String word;
    private int startOffset;
    private int endOffset;

    public Word(String word) {
        this.word = word;
    }

    public Word(String word, int startOffset, int endOffset) {
        this.word = word;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public Word(Type type, String word, int startOffset, int endOffset) {
        this(word, startOffset, endOffset);
        this.type = type;
    }

    public String getWord() {
        return this.word;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.word;
    }

    public boolean containsPosition(int position) {
        return this.startOffset <= position && position <= this.endOffset;
    }

    public static String toString(List<Word> words, int startIndex) {
        return Word.toString(words, startIndex, ListSequence.fromList(words).count() - 1);
    }

    public static String toString(List<Word> words, int startIndex, int endIndex) {
        if (words == null) {
            return "";
        }
        if (startIndex > endIndex) {
            return "";
        }
        if (endIndex < 0 || ListSequence.fromList(words).count() <= endIndex) {
            return "";
        }
        return Word.toString(words, startIndex, endIndex, ((Word)ListSequence.fromList(words).getElement(endIndex)).getEndOffset() - ((Word)ListSequence.fromList(words).getElement(endIndex)).getStartOffset());
    }

    public static String toString(List<Word> words, int startIndex, int endIndex, int endOffset) {
        if (words == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            sb.append(((Word)ListSequence.fromList(words).getElement(i)).getWord());
        }
        sb.append(StringUtils.substring(((Word)ListSequence.fromList(words).getElement(endIndex)).getWord(), 0, endOffset));
        return sb.toString();
    }

    public static String[] toStrings(List<Word> words, int startToken, int endToken) {
        if (words == null) {
            return null;
        }
        String[] res = new String[endToken - startToken + 1];
        for (int i = startToken; i <= endToken; ++i) {
            res[i - startToken] = ((Word)ListSequence.fromList(words).getElement(i)).getWord();
        }
        return res;
    }

    public static void append(StringBuilder sb, List<Word> words, int startIndex, int endIndex, int endOffset) {
        if (words == null) {
            return;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            sb.append(((Word)ListSequence.fromList(words).getElement(i)).getWord());
        }
        if (endOffset >= 0) {
            sb.append(StringUtils.substring(((Word)ListSequence.fromList(words).getElement(endIndex)).getWord(), 0, endOffset));
        } else {
            sb.append(((Word)ListSequence.fromList(words).getElement(endIndex)).getWord());
        }
    }

    public static int length(List<Word> words, int start, int end) {
        if (words == null) {
            return 0;
        }
        int len = 0;
        while (start <= end && start >= 0 && start < ListSequence.fromList(words).count()) {
            len += ((Word)ListSequence.fromList(words).getElement(start)).getWord().length();
            ++start;
        }
        return len;
    }

    public static int getStartOffset(List<Word> words, int wordIndex) {
        if (ListSequence.fromList(words).isEmpty()) {
            return 0;
        }
        if (wordIndex >= ListSequence.fromList(words).count()) {
            return ((Word)ListSequence.fromList(words).getElement(ListSequence.fromList(words).count() - 1)).getEndOffset();
        }
        return ((Word)ListSequence.fromList(words).getElement(wordIndex)).getStartOffset();
    }

    public static enum Type {
        SPACE,
        PUNCTUATION,
        TOKEN;

    }
}

