/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.parser.runtime.prefixTree;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import jetbrains.mps.parser.runtime.prefixTree.DateNode;

public class DateLiteral {
    public static final int YEAR_INDEX = 0;
    public static final int YEAR_LENGTH = 4;
    public static final int MONTH_INDEX = 4;
    public static final int MONTH_LENGTH = 2;
    public static final int DAY_INDEX = 6;
    public static final int DAY_LENGTH = 2;
    public static final int HOUR_INDEX = 8;
    public static final int HOUR_LENGTH = 2;
    public static final int MINUTE_INDEX = 10;
    public static final int MINUTE_LENGTH = 2;
    public static final int SECOND_INDEX = 12;
    public static final int SECOND_LENGTH = 2;
    private DateNode node;
    private byte[] data = new byte[14];

    public DateLiteral(DateNode node) {
        this.node = node;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = -1;
        }
    }

    public String getSuggestion(TimeZone timeZone) {
        Calendar calendar = this.toCalendar(timeZone);
        String format = this.node.getSuggestionFormat(this);
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(timeZone);
        return formatter.format(calendar.getTime());
    }

    public String getFormat() {
        return this.node.getFormatPresentation(this);
    }

    public DateNode getNode() {
        return this.node;
    }

    public void setNode(DateNode node) {
        this.node = node;
    }

    public void setDigit(int index, int digit) {
        this.data[index] = (byte)digit;
    }

    public Calendar toCalendar(TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        byte[] current = new byte[14];
        this.setValue(current, 0, 4, calendar.get(1));
        this.setValue(current, 4, 2, calendar.get(2) + 1);
        this.setValue(current, 6, 2, calendar.get(5));
        this.setValue(current, 8, 2, calendar.get(11));
        this.setValue(current, 10, 2, calendar.get(12));
        this.setValue(current, 12, 2, calendar.get(13));
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == -1) continue;
            current[i] = this.data[i];
        }
        calendar.set(5, 1);
        int value = this.getValue(current, 0, 4);
        calendar.set(1, value);
        value = this.getValue(current, 4, 2);
        this.setInRange(calendar, 2, value - 1);
        value = this.getValue(current, 6, 2);
        this.setInRange(calendar, 5, value);
        value = this.getValue(current, 8, 2);
        this.setInRange(calendar, 11, value);
        value = this.getValue(current, 10, 2);
        this.setInRange(calendar, 12, value);
        value = this.getValue(current, 12, 2);
        this.setInRange(calendar, 13, value);
        return calendar;
    }

    private void setInRange(Calendar calendar, int calendarField, int value) {
        int min = calendar.getActualMinimum(calendarField);
        int max = calendar.getActualMaximum(calendarField);
        calendar.set(calendarField, Math.max(min, Math.min(value, max)));
    }

    public int getDaysInMoth() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(5, 1);
        if (this.getYear() != -1) {
            calendar.set(1, this.getYear());
        }
        if (this.getMonth() != -1) {
            calendar.set(2, this.getMonth() - 1);
        }
        return ((Calendar)calendar).getActualMaximum(5);
    }

    public int getYear() {
        return this.getValue(this.data, 0, 4);
    }

    public int getMonth() {
        return this.getValue(this.data, 4, 2);
    }

    public int getDay() {
        return this.getValue(this.data, 6, 2);
    }

    public int getHour() {
        return this.getValue(this.data, 8, 2);
    }

    public int getMinute() {
        return this.getValue(this.data, 10, 2);
    }

    public int getSecond() {
        return this.getValue(this.data, 12, 2);
    }

    private int getValue(byte[] data, int index, int length) {
        int value = -1;
        if (data[index] != -1) {
            value = 0;
            for (int i = index; i < index + length; ++i) {
                byte d = data[i];
                value = value * 10 + (d != -1 ? d : (byte)0);
            }
        }
        return value;
    }

    private void setValue(byte[] data, int index, int length, int value) {
        for (int i = index + length - 1; i >= index; --i) {
            data[i] = (byte)(value % 10);
            value /= 10;
        }
    }

    public static enum Type {
        YEAR,
        MONTH,
        HOUR;

        private DateNode rootNode;

        public DateNode getRootNode() {
            return this.rootNode;
        }

        public void setRootNode(DateNode rootNode) {
            this.rootNode = rootNode;
        }
    }
}

