/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.springframework.configuration.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.springframework.configuration.runtime.IServiceLocator;
import jetbrains.springframework.configuration.runtime.MyClassPathXmlApplicationContext;
import jetbrains.springframework.configuration.runtime.MyClassPathXmlApplicationContextCreator;
import jetbrains.springframework.configuration.runtime.PlaceholderResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class AbstractServiceLocator
implements IServiceLocator {
    public static final MyClassPathXmlApplicationContextCreator DEFAULT_CONTEXT_CREATOR = new MyClassPathXmlApplicationContextCreator(){

        @Override
        public MyClassPathXmlApplicationContext create(String[] configLocations) throws BeansException {
            return new MyClassPathXmlApplicationContext(configLocations);
        }
    };
    private static final Log log = LogFactory.getLog(AbstractServiceLocator.class);
    @NotNull
    private final AbstractApplicationContext applicationContext;
    protected final Map<String, Object> nameToBean = new HashMap<String, Object>();
    protected final PlaceholderResolver resolver;
    private volatile boolean closed = false;

    protected AbstractServiceLocator(String[] configs, boolean registerShutdownHooks) {
        this(configs, registerShutdownHooks, DEFAULT_CONTEXT_CREATOR);
    }

    protected AbstractServiceLocator(String[] configs, boolean registerShutdownHooks, MyClassPathXmlApplicationContextCreator creator) {
        this.logAllInitConfigs(configs);
        this.applicationContext = creator.create(AbstractServiceLocator.addDatabaseConfigsLocations(configs));
        this.resolver = this.doCreatePlaceholderResolver();
        this.registerPostProcessor((BeanFactoryPostProcessor)this.resolver);
        if (log.isInfoEnabled()) {
            log.info((Object)("Adding default placeholder resolver: " + ((Object)((Object)this.resolver)).getClass().getSimpleName()));
        }
        if (registerShutdownHooks) {
            this.applicationContext.registerShutdownHook();
        }
    }

    protected final void registerPostProcessor(BeanFactoryPostProcessor beanFactoryPostProcessor) {
        this.applicationContext.addBeanFactoryPostProcessor(beanFactoryPostProcessor);
    }

    protected void logAllInitConfigs(String[] configs) {
        if (log.isInfoEnabled()) {
            log.info((Object)"----------------------------------------");
            log.info((Object)"Init xml spring configuration with configs: ");
            for (String c : configs) {
                log.info((Object)("    " + c));
            }
            log.info((Object)"----------------------------------------");
        }
    }

    @Override
    public PlaceholderResolver getResolver() {
        return this.resolver;
    }

    @Override
    public boolean isFake() {
        return false;
    }

    @Override
    public synchronized void init() {
        this.closed = false;
        this.applicationContext.refresh();
    }

    protected final ConfigurableListableBeanFactory getBeanFactory() {
        return this.applicationContext.getBeanFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getBean(String id) {
        this.checkClosed(id);
        Map<String, Object> map = this.nameToBean;
        synchronized (map) {
            Object res = this.nameToBean.get(id);
            if (res == null) {
                res = this.getBeanFactory().getBean(id);
                this.nameToBean.put(id, res);
            }
            return res;
        }
    }

    @Override
    public boolean beanDefined(String id) {
        this.checkClosed(id);
        return this.getBeanFactory().containsBean(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setTestBean(String id, Object testBeanImplementation) {
        this.checkClosed(id);
        Map<String, Object> map = this.nameToBean;
        synchronized (map) {
            this.nameToBean.put(id, testBeanImplementation);
        }
    }

    @Override
    public Object getOptionalBean(String id) {
        this.checkClosed(id);
        return this.getBeanFactory().containsBean(id) ? this.getBean(id) : null;
    }

    @Override
    public Map getBeansOfType(Class type) {
        this.checkClosed(type.toString());
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getBeanFactory(), (Class)type);
    }

    @Override
    public Map getLocalBeansOfType(Class type) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public ResourcePatternResolver getResourceLoader() {
        return this.applicationContext;
    }

    @Override
    public synchronized void close() {
        log.debug((Object)"Close xml spring configuration.");
        this.closed = true;
        this.applicationContext.close();
        this.nameToBean.clear();
    }

    @Override
    public void closeLocal() {
    }

    protected PlaceholderResolver doCreatePlaceholderResolver() {
        return new PlaceholderResolver();
    }

    private static String[] addDatabaseConfigsLocations(String[] configs) {
        ArrayList<String> res = new ArrayList<String>();
        for (String c : configs) {
            if (c == null) continue;
            res.add(c);
            if (c.contains("*.")) {
                res.add(c.replace("*.", "*ConfigurationDatabase."));
                continue;
            }
            res.add(c.replace("*Configuration.xml", "*ConfigurationDatabase.xml"));
        }
        return res.toArray(new String[res.size()]);
    }

    public final boolean isClosed() {
        return this.closed;
    }

    protected void checkClosed(String beanName) {
        if (this.isClosed()) {
            throw new BeanCreationNotAllowedException(beanName, "Bean creation not allowed while this factory is in destruction (Do not request a bean from a BeanFactory in a destroy method implementation!)");
        }
    }
}

