/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.springframework.configuration.runtime;

import jetbrains.springframework.configuration.runtime.MyPathMatchingResourcePatternResolver;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;

public class MyClassPathXmlApplicationContext
extends GenericXmlApplicationContext {
    private static final Log log = LogFactory.getLog(MyClassPathXmlApplicationContext.class);

    public MyClassPathXmlApplicationContext(String[] configs, boolean allowBeanDefinitionOverriding) throws BeansException {
        this.setAllowBeanDefinitionOverriding(allowBeanDefinitionOverriding);
        this.setValidating(false);
        this.load(configs);
    }

    public MyClassPathXmlApplicationContext(String[] configs) throws BeansException {
        this(configs, true);
    }

    protected void onClose() {
        ServiceLocator.deinit();
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        try {
            Class.forName("org.jboss.virtual.VirtualFileVisitor");
            Class<?> c = Class.forName("org.jboss.spring.vfs.VFSResourcePatternResolver");
            ResourcePatternResolver resolver = (ResourcePatternResolver)c.newInstance();
            log.info((Object)"Run under jboss 5.x");
            log.info((Object)"Use jboss speific resource pattern resolver.");
            return resolver;
        }
        catch (Throwable e) {
            log.info((Object)"Use patched resource pattern resolver.");
            return new MyPathMatchingResourcePatternResolver((ResourceLoader)this);
        }
    }
}

