/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.htmlComponent.bl;

import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.parser.runtime.base.StyleRange;
import jetbrains.mps.parser.runtime.base.SuggestItem;
import jetbrains.mps.parser.runtime.base.SuggestItemSeparator;
import jetbrains.mps.webr.htmlComponent.bl.Range;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import webr.framework.runtime.response.CommandResponseAction;
import webr.framework.runtime.response.CommandScriptor;
import webr.framework.runtime.response.JsCommandResponse;
import webr.framework.textBuilder.TBuilderContext;

public class HtmlTextComponent {
    public static JsCommandResponse underline(final String component, final String query, final Iterable<Range> ranges, final int optinalLeftOffset) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").underline(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)query));
                builderContext.append("\", [");
                boolean first = true;
                if (ranges != null) {
                    for (Range range : Sequence.fromIterable((Iterable)ranges)) {
                        int start = range.getStart();
                        int end = range.getEnd();
                        if (!first) {
                            builderContext.append(",");
                        } else {
                            first = false;
                        }
                        builderContext.append("{start: ");
                        builderContext.append(String.valueOf(start));
                        builderContext.append(", end: ");
                        builderContext.append(String.valueOf(end));
                        builderContext.append(", type: ");
                        builderContext.append(String.valueOf(range.getType()));
                        builderContext.append("}");
                    }
                }
                builderContext.append("], ");
                builderContext.append(String.valueOf(optinalLeftOffset));
                builderContext.append(");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse styledUnderline(final String component, final String query, final Iterable<StyleRange> ranges, final int optinalLeftOffset) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").underline(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)query));
                builderContext.append("\", [");
                boolean first = true;
                if (ranges != null) {
                    for (StyleRange range : Sequence.fromIterable((Iterable)ranges)) {
                        String title;
                        int start = range.getStartOffset();
                        int end = range.getStartOffset() + range.getLength();
                        String styleClass = range.getStyleClass();
                        String string = title = HtmlTextComponent.isNotEmpty_d3lfdu_a0a0d0a0b0j0a0a0a0a1a1a1(range.getTitle()) ? range.getTitle() : "";
                        if (!first) {
                            builderContext.append(",");
                        } else {
                            first = false;
                        }
                        builderContext.append("{start: ");
                        builderContext.append(String.valueOf(start));
                        builderContext.append(", end: ");
                        builderContext.append(String.valueOf(end));
                        builderContext.append(", styleClass: \"");
                        builderContext.append(JsStringUtil.stringLiteral((Object)styleClass));
                        builderContext.append("\", title: \"");
                        builderContext.append(JsStringUtil.stringLiteral((Object)title));
                        builderContext.append("\"}");
                    }
                }
                builderContext.append("], ");
                builderContext.append(String.valueOf(optinalLeftOffset));
                builderContext.append(");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse suggest(final String component, final String query, final int caret, final Iterable<SuggestItem> suggestions) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").suggest({query: \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)query));
                builderContext.append("\", caret: ");
                builderContext.append(String.valueOf(caret));
                builderContext.append(", items: [");
                boolean first = true;
                if (suggestions != null) {
                    for (SuggestItem suggestItem : Sequence.fromIterable((Iterable)suggestions)) {
                        if (!first) {
                            builderContext.append(",");
                        } else {
                            first = false;
                        }
                        builderContext.append("{");
                        if (suggestItem instanceof SuggestItemSeparator) {
                            builderContext.append("sep: true,");
                            builderContext.append("d:");
                            builderContext.append("\"");
                            builderContext.append(JsStringUtil.stringLiteral((Object)suggestItem.getDescription()));
                            builderContext.append("\"");
                        } else {
                            builderContext.append("o:");
                            builderContext.append("\"");
                            builderContext.append(JsStringUtil.stringLiteral((Object)suggestItem.getOption()));
                            builderContext.append("\"");
                            builderContext.append(",");
                            builderContext.append("d:");
                            builderContext.append("\"");
                            builderContext.append(JsStringUtil.stringLiteral((Object)suggestItem.getDescription()));
                            builderContext.append("\"");
                            builderContext.append(",");
                            if (suggestItem.isHtmlDescription()) {
                                builderContext.append("hd:true,");
                            }
                            if (suggestItem.isComplete()) {
                                builderContext.append("c:true,");
                            }
                            builderContext.append("t:");
                            builderContext.append(suggestItem.getSuggestionType());
                            builderContext.append(",");
                            if (HtmlTextComponent.isNotEmpty_d3lfdu_a0j0a2a0a1a11a0a0a0a0e0b0c(suggestItem.getPrefix())) {
                                builderContext.append("pre:");
                                builderContext.append("\"");
                                builderContext.append(JsStringUtil.stringLiteral((Object)suggestItem.getPrefix()));
                                builderContext.append("\"");
                                builderContext.append(",");
                            }
                            if (HtmlTextComponent.isNotEmpty_d3lfdu_a0k0a2a0a1a11a0a0a0a0e0b0c(suggestItem.getSuffix())) {
                                builderContext.append("suf:");
                                builderContext.append("\"");
                                builderContext.append(JsStringUtil.stringLiteral((Object)suggestItem.getSuffix()));
                                builderContext.append("\"");
                                builderContext.append(",");
                            }
                            builderContext.append("cp:");
                            builderContext.append(suggestItem.getCaretPosition());
                            builderContext.append(",");
                            builderContext.append("cs:");
                            builderContext.append(suggestItem.getCompletionStart());
                            builderContext.append(",");
                            builderContext.append("ce:");
                            builderContext.append(suggestItem.getCompletionEnd());
                            builderContext.append(",");
                            builderContext.append("ms:");
                            builderContext.append(suggestItem.getMatchingStart());
                            builderContext.append(",");
                            builderContext.append("me:");
                            builderContext.append(suggestItem.getMatchingEnd());
                        }
                        builderContext.append("}\n");
                    }
                }
                builderContext.append("]});");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse highlight(final String component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").highlight(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse highlight(final String component, final String message, final boolean dismissOnChange, final boolean focus) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").highlight(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", null, ");
                builderContext.append(Boolean.toString(dismissOnChange));
                builderContext.append(", ");
                builderContext.append(Boolean.toString(focus));
                builderContext.append(");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse unHighlight(final String component) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").unHighlight();");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse focus(final String component) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").focus();");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static boolean isNotEmpty_d3lfdu_a0a0d0a0b0j0a0a0a0a1a1a1(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_d3lfdu_a0j0a2a0a1a11a0a0a0a0e0b0c(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_d3lfdu_a0k0a2a0a1a11a0a0a0a0e0b0c(String str) {
        return str != null && str.length() > 0;
    }
}

