Webr.component.ComboBoxComponent = function (element, renderer) {
  this.searchContext = "";
  this.pager = null;
  this.noMatch = {text: "<" + l10n('${l10n("ComboBoxComponent.js.no_matches")}') + ">", id: Webr.component.ComboOption.NO_MATCH_ID, empty: false, styleClass: "nomatch"};
  Webr.component.ComboBoxComponent.superclass.constructor.call(this, element, (renderer = renderer || new Webr.component.ComboRenderer(element, Webr.component.ComboComponentBase.findRoot(element))));
  renderer.setConfig({containerClass: this.getCustomCssClass(), maxListHeight: element.getAttribute("maxheight"), minListHeight: element.getAttribute("minheight")});
  var it = this;
  var arrow = $(element).find("a." + "arrow");
  if (arrow.get(0)) {
    arrow.unbind("click");
    arrow.bind("click", function () {
      it.toggle();
    });
  }

  this.selectionListener = {selectionChanged: function () {
    it.inputElement.setValueNoEvents(it.dataList.getCurrentOption().text);
    it.updateSelection();
  }};
};
{
  var F = new Function();
  F.prototype = Webr.component.ComboComponentBase.prototype;
  Webr.component.ComboBoxComponent.prototype = new F();
  Webr.component.ComboBoxComponent.prototype.constructor = Webr.component.ComboBoxComponent;
  Webr.component.ComboBoxComponent.superclass = Webr.component.ComboComponentBase.prototype;
}

Webr.component.ComboBoxComponent.prototype.setSearchContext = function (value) {
  if (!(value.equalsIgnoreCase(this.searchContext))) {
    this.dataList.narrow(value);
    this.searchContext = value;
    this.renderer.repaint();
  }

};
Webr.component.ComboBoxComponent.prototype.fireKeyDown = function (e) {
  if (e.isKey(Webr.util.Key.ENTER)) {
    this.onEnter();
  }

  if (e.isKey(Webr.util.Key.ESC)) {
    this.onEsc();
  }

  var it = this;
  return this.fire(function (l) {
    if (l.keyDown) {
      return l.keyDown(it, e);
    } else {
      return true;
    }

  });
};
Webr.component.ComboBoxComponent.prototype.sync = function () {
  var o = this.currentOption;
  if (!this.remote) {
    //reset search context if loading is not required
    this.setSearchContext("");
    //set current option as selected in data list
    this.dataList.setCurrentOption(o);
  } else {
    if (this.searchContext.length != 0) {
      //on loading we need trigger context change
      this.onInitValueChanged = true;
      this.searchContext = "";
    } else {
      this.dataList.setCurrentOption(o);
    }

  }

  //set input field text equal to current option value
  this.inputElement.setValueNoEvents(o != null ?o.text :"");
};
Webr.component.ComboBoxComponent.prototype.loadRequired = function () {
  return this.remote && this.searchContext.length != 0;
};
Webr.component.ComboBoxComponent.prototype.makeVisible = function () {
  this.renderer.show();
  this.showOptions();
};
Webr.component.ComboBoxComponent.prototype.getCurentOption = function () {
  return this.currentOption;
};
Webr.component.ComboBoxComponent.prototype.showOptions = function () {
  this.jQinputElement.removeClass("empty");
  this.setFocusNoEvents();
  this.onShowOptions();
};
Webr.component.ComboBoxComponent.prototype.makeHidden = function () {
  this.renderer.hide();
  this.hideOptions();
};
Webr.component.ComboBoxComponent.prototype.hideOptions = function () {
  var option = this.currentOption;
  if (option != null && option.empty) {
    this.jQinputElement.addClass("empty");
  } else if (option == null && this.inputElement.value === "") {
    this.jQinputElement.addClass("empty");
  }

  this.onHideOptions();
};
Webr.component.ComboBoxComponent.prototype.resetCurrentOption = function () {
  this.setCurrent(this.currentOption, false);
};
Webr.component.ComboBoxComponent.prototype.updateSelection = function () {
  var text = this.inputElement.value;
  if (this.searchContext !== "" && text.startsWith(this.searchContext)) {
    if (text.equalsIgnoreCase(this.searchContext)) {
      this.inputElement.select();
    } else {
      this.inputElement.setSelectionRange(this.searchContext.length, text.length);
    }

  } else {
    this.inputElement.select();
  }

};
Webr.component.ComboBoxComponent.prototype.reset = function () {
  this.setCurrent(this.defaultOption, true);
  this.sync();
  this.blur();
  this.drop();
};
Webr.component.ComboBoxComponent.prototype.initDataList = function (remote) {
  if (!this.dataList) {
    var list;
    var config = {clickHandler: jQuery.proxy(this.mOptionClicked, this), circle: this.mainElement.attr("nocircle") ?false :true};
    if (remote) {
      //that list is remote - it's not local anymore
      this.local = false;
      list = new Webr.component.RemoteDataList(this, config);
    } else {
      list = new Webr.component.MemoryDataList(config);
    }

    list.addNoMatchOption(new Webr.component.ComboBoxListItem(this.noMatch));
    list.addListener(this.selectionListener);
    this.dataList = list;
  }

};
Webr.component.ComboBoxComponent.prototype.initOption = function () {
  if (!this.currentOption) {
    this.currentOption = this.dataList.getCurrentOption();
  }

  if (!this.defaultOption) {
    this.defaultOption = this.currentOption;
  }

};
Webr.component.ComboBoxComponent.prototype.update = function (options, size, from, to, hidePagination, pageSize, exactSize) {
  //If it has size, so we should render list remotely
  this.remote = size !== undefined;
  this.initDataList(this.remote);
  if (hidePagination) {
    this.pager && this.pager.hide();
  } else if (this.remote) {
    this.updatePager(from, to, size, pageSize, exactSize);
    this.pager.show();
  }

  //if search context set then no selected option neccessary
  var selectedId = this.searchContext.equalsIgnoreCase("") ?this.jQinputElement.attr("valueId") :"";
  this.dataList.update(options, function (o) {
    return new Webr.component.ComboBoxListItem(o);
  }, selectedId);
  this.initOption();
  //Render list
  this.renderList();
  //Call event after loading
  this.loaded();
};
Webr.component.ComboBoxComponent.prototype.setCurrent = function (o, updateInput) {
  this.currentOption = o;
  if (updateInput) {
    this.updateInputValueId(o != null ?o.id :"");
  }

};
Webr.component.ComboBoxComponent.prototype.updateInputValueId = function (valueId) {
  this.inputElement.setAttribute("valueId", valueId);
};
Webr.component.ComboBoxComponent.prototype.renderList = function () {
  if (this.pager) {
    this.renderer.addExtraContent(this.pager.getElement());
  }

  this.renderer.draw(this.dataList);
};
Webr.component.ComboBoxComponent.prototype.getCustomCssClass = function () {
  var c = this.mainElement.attr("customClass");
  return c ?c :"";
};
Webr.component.ComboBoxComponent.prototype.submit = function (option) {
  //if current text doesn't match any option - trigg special event, else submit option
  if (option) {
    this.setCurrent(option, true);
    this.onchange();
  } else {
    this.submitInputValue();
  }

  this.fire(function (l) {
    l.submitted(option);
  });
};
Webr.component.ComboBoxComponent.prototype.submitInputValue = function () {
  this.onSubmitAbsentOption(this.inputElement.value);
};
Webr.component.ComboBoxComponent.prototype.lessClicked = function (skip) {
  this.onLoad(this.searchContext, skip);
};
Webr.component.ComboBoxComponent.prototype.moreClicked = function (skip) {
  this.onLoad(this.searchContext, skip);
};
Webr.component.ComboBoxComponent.prototype.callLoading = function (prefix) {
  if (this.local) {
    this.loadLocal(prefix);
  } else {
    this.onLoad(prefix);
  }

};
Webr.component.ComboBoxComponent.prototype.updatePager = function (from, to, size, pageSize, exactSize) {
  if (!(this.pager)) {
    var it = this;
    this.pager = new Webr.component.Pager(function (skip) {
      it.moreClicked(skip);
    }, function (skip) {
      it.lessClicked(skip);
    });
  }

  this.pager.update(from, to, size, pageSize, exactSize);
};
Webr.component.ComboBoxComponent.prototype.loadLocal = function (prefix) {
  var dataStore = this.mainElement.find("div." + "comboboxList");
  //text() returns String if no parameters set
  var text = dataStore.text();
  dataStore.remove();
  if (text) {
    //release context, then eval
    window.setTimeout(function () {
      eval(text);
    }, 10);
  }

};
Webr.component.ComboBoxComponent.prototype.onLoad = function (prefix, skip) {
  this.mainElement.trigger("Load", {prefix: prefix, skip: skip});
};
Webr.component.ComboBoxComponent.prototype.onchange = function () {
  this.mainElement.trigger("change");
};
Webr.component.ComboBoxComponent.prototype.onEnter = function () {
};
Webr.component.ComboBoxComponent.prototype.onEsc = function () {
};
Webr.component.ComboBoxComponent.prototype.onSubmitAbsentOption = function (value) {
  this.mainElement.trigger("SubmitAbsentOption", {value: value});
};
Webr.component.ComboBoxComponent.prototype.onShowOptions = function () {
  this.mainElement.trigger("ShowOptions");
};
Webr.component.ComboBoxComponent.prototype.onHideOptions = function () {
  this.mainElement.trigger("HideOptions");
};
Webr.component.ComboBoxComponent.CB_COMPONENT_DATA = "_combo_component_data_";
Webr.component.ComboBoxComponent.register = function (path, comboboxSuffixName) {
  cr.forEach(path, comboboxSuffixName, function () {
    var e = $(this);
    var bindToId = e.attr("bid");
    var ff = function () {
      if (bindToId) {
        return new Webr.component.ComboBoxComponentBind(e.get(0), document.getElementById(bindToId));
      }

      return new Webr.component.ComboBoxComponent(e.get(0));
    };
    if (bindToId) {
      var bindTo = $(document.getElementById(bindToId));
      var _f = function (e) {
        //ignore click to links & images
        if (e.targetIs(["A", "IMG"]) && e.target != bindTo.get(0)) {
          bindTo.one("click", _f);
        } else {
          ff().toggle();
          return false;
        }

      };
      bindTo.one("click", _f);
    } else {
      var div = e.children("div");
      var input = div.children("input");
      var a = div.siblings("a");
      if (input.attr("disabled")) {
        //component disabled do not register
        e.addClass("combo-disabled");
        return ;
      }

      //e is input 
      input.one("focus", function () {
        ff().focus();
      });
      //downarrow near input
      a.one("click", function () {
        //if combobox inited - focus and show options
        ff().toggle();
      });
    }

  });
};
Webr.component.ComboBoxComponent.register2 = function (element, e) {
  //Used hack if click is called from jQuery in Chrome it can not contain any events
  var evt = e || window.event || {};
  var target = $(evt.srcElement ?evt.srcElement :evt.target);
  if (target && target.matches(["A", "IMG"]) && !(target.equals($(element).children()))) {
    return true;
  }

  var div = $(element).data(Webr.component.ComboBoxComponent.CB_COMPONENT_DATA) || $(element).next("div");
  var combo = $(div).data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE);
  if (!combo) {
    $(element).data(Webr.component.ComboBoxComponent.CB_COMPONENT_DATA, div.get ?div.get(0) :div);
    combo = new Webr.component.ComboBoxComponentBind(div.get(0), $(element).children().get(0));
    div.bind("ShowOptions", function () {
      $(element).children().addClass("active");
    }).bind("HideOptions", function () {
      $(element).children().removeClass("active");
    });
    $(element).unbind("click");
  }

  combo.toggle();
  return false;
};
Webr.component.ComboBoxComponent.safeFocus = function (combo) {
  var c = Webr.component.ComboBoxComponent.getComboBoxInput(combo);
  c.focus();
  c.select();
};
Webr.component.ComboBoxComponent.getComboBoxInput = function (combo) {
  var c;
  if (combo.finalize) {
    c = combo.jQinputElement;
  } else {
    c = $(combo).find("input");
  }

  return c;
};
Webr.component.ComboBoxComponent.getValueId = function (combo) {
  return Webr.component.ComboBoxComponent.getComboBoxInput(combo).attr("valueid");
};
Webr.component.ComboBoxComponent.safeReset = function (combo) {
  var c;
  if (combo.reset) {
    c = combo.reset();
  }

};
Webr.component.ComboBoxListItem = function (option) {
  Webr.component.ComboBoxListItem.superclass.constructor.call(this, option);
};
{
  var F = new Function();
  F.prototype = Webr.component.DataListItem.prototype;
  Webr.component.ComboBoxListItem.prototype = new F();
  Webr.component.ComboBoxListItem.prototype.constructor = Webr.component.ComboBoxListItem;
  Webr.component.ComboBoxListItem.superclass = Webr.component.DataListItem.prototype;
}

Webr.component.ComboBoxListItem.prototype.createElement = function () {
  var li = $(document.createElement("li"));
  this.el = li;
  li.addClass(this.option.styleClass);
  if (Webr.component.ComboOption.NO_MATCH_ID === this.option.id) {
    li.text(this.option.text);
    this.hide();
  } else {
    if (this.option.h) {
      li.html(this.option.text);
    } else {
      li.text(this.option.text);
      li.attr("title", this.option.text);
    }

  }

};
Webr.component.ComboBoxListItem.prototype.scroll = function () {
  this.el.scrollTo(this.el.parent().get(0));
};
Webr.component.ComboBoxListItem.prototype.registerClickHandler = function (handler) {
  var it = this;
  this.el.click(function (event) {
    handler.call(it, it.option);
    return false;
  });
};
Webr.component.Pager = function (moreHandler, lessHandler) {
  this.moreHandler = moreHandler;
  this.lessHandler = lessHandler;
  this.me = $(document.createElement("div")).addClass("pager");
};
Webr.component.Pager.prototype.update = function (from, to, size, pageSize, exactSize) {
  var it = this;
  this.me.children().remove();
  if (from > 0) {
    var prev = $(document.createElement("a")).html("&laquo; " + l10n('${l10n("ComboBoxComponent.js.prev")}')).attr("href", "javascript:void(0)");
    this.me.append(prev);
    prev.click(function () {
      it.lessHandler(Math.max(0, from - pageSize));
    });
  }

  this.me.append("<span>" + (from + 1) + "-" + to + " of " + size + (exactSize ?"" :"+") + "</span>");
  if (to < size || (exactSize != undefined && !exactSize)) {
    var next = $(document.createElement("a")).html(l10n('${l10n("ComboBoxComponent.js.next")}') + " &raquo;").attr("href", "javascript:void(0)");
    this.me.append(next);
    next.click(function () {
      it.moreHandler(to);
    });
  }

};
Webr.component.Pager.prototype.getElement = function () {
  return this.me;
};
Webr.component.Pager.prototype.show = function () {
  this.me.show();
};
Webr.component.Pager.prototype.hide = function () {
  this.me.hide();
};
var regCC = Webr.component.ComboBoxComponent.register;
var regCC2 = Webr.component.ComboBoxComponent.register2;
