Webr.component.ComboRenderer = function (mainElement, rootElement, layouter) {
  Webr.component.ComboRenderer.superclass.constructor.call(this, mainElement);
  this.setLayouter(new Webr.component.VerticalLayouter(this.getLayouterConfig()));
  this.setRootElement($(rootElement));
};
{
  var F = new Function();
  F.prototype = Webr.component.BaseComboRenderer.prototype;
  Webr.component.ComboRenderer.prototype = new F();
  Webr.component.ComboRenderer.prototype.constructor = Webr.component.ComboRenderer;
  Webr.component.ComboRenderer.superclass = Webr.component.BaseComboRenderer.prototype;
}

Webr.component.ComboRenderer.prototype.getLayouterConfig = function () {
  //TODO: Bad decision to get it from method
  var it = this;
  return {anchor: it.mainElement, move: jQuery.proxy(it.move, it), reset: jQuery.proxy(it.reset, it)};
};
Webr.component.ComboRenderer.prototype.createComboContainer = function () {
  if (this.comboContainer) {
    return this.comboContainer;
  }

  var position = this.countPosition();
  this.comboContainer = $(document.createElement("div")).addClass("contentWrapper").addClass(this.config.containerClass).css("left", position.left).css("width", this.mainElement.width()).hide();
  //For debug & testing cases
  this.comboContainer.attr("_cn_", this.mainElement.get(0).id);
  return this.comboContainer;
};
Webr.component.ComboRenderer.prototype.countPosition = function () {
  var pos = {top: this.getMainElement().offset().top - this.rootElement.offset().top, left: this.getMainElement().offset().left - this.rootElement.offset().left};
  var position = {top: pos.top + this.getMainElement().outerHeight(true), left: pos.left};
  return position;
};
Webr.component.ComboRenderer.prototype.getList = function () {
  if (this.listContainer) {
    return this.listContainer;
  }

  this.listContainer = $(document.createElement("ul")).addClass("comboboxList");
  return this.listContainer;
};
Webr.component.ComboRenderer.prototype.createExtraContainer = function () {
  if (this.extraContainer) {
    return this.extraContainer;
  }

  this.extraContainer = $(document.createElement("div")).addClass("extraContent").css("width", this.mainElement.width());
  return this.extraContainer;
};
Webr.component.ComboRenderer.prototype.draw = function (dataList) {
  var list = this.getList();
  if (!this.drawn) {
    var listContainer = this.createComboContainer();
    listContainer.append(list);
    if (this.extraContents) {
      var extras = this.createExtraContainer();
      this.extraContents.forEach(function (c) {
        extras.append(c);
      });
      listContainer.append(extras);
    }

    this.rootElement.append(listContainer);
    this.drawn = true;
    this.shadow = Webr.component.Shadow.getShadow(listContainer, "ie-combo-shadow");
    this.shadow.setTop(listContainer.offset().top);
  } else {
    list.children().remove();
  }

  dataList.forEach(function (item) {
    list.append(item.getElement());
  });
};
Webr.component.ComboRenderer.prototype.repaint = function () {
  this.shadow.setHeight(this.createComboContainer().outerHeight());
};
Webr.component.ComboRenderer.prototype.move = function (direction, maxHeight, preffered) {
  var pos = this.countPosition();
  var d = Webr.component.Shadow.SHADOW_DELTA;
  switch (direction) {
  case Webr.component.Layouter.UP:
    this.getContainer().addClass("reversal");
    this.shadow.relayout(true);
    pos.top -= this.getMainElement().outerHeight(true);
    this.setComboContainerPositionAndHeight(pos.top, maxHeight, preffered);
    d = this.listContainer.outerHeight(true) + Webr.component.Shadow.SHADOW_DELTA;
    this.setExtraContentPosition();
        break;

  case Webr.component.Layouter.DOWN:
    this.setComboContainerPositionAndHeight(pos.top, maxHeight, preffered);
    this.setExtraContentPosition();
        break;

  }

  this.comboContainer.css("left", pos.left);
  this.shadow.setTop(pos.top - d);
  this.shadow.setLeft(pos.left);
};
Webr.component.ComboRenderer.prototype.reset = function () {
  this.comboContainer.removeClass("reversal").css("top", this.countPosition().top);
  this.listContainer.css("max-height", "").css("overflow-y", "");
};
