Webr.component.Debug = function () {
};
Webr.component.Debug.div = null;
Webr.component.Debug.ta = null;
Webr.component.Debug.DEBUG = true;
Webr.component.Debug.info = function (s) {
  Webr.component.Debug.consoleMethod("log", Webr.component.Debug.getTime() + ": " + s);
};
Webr.component.Debug.trace = function (s) {
  info(s);
};
Webr.component.Debug.getTime = function () {
  var d = new Date();
  return [d.getHours(), d.getMinutes(), d.getSeconds(), d.getMilliseconds()].join(":");
};
Webr.component.Debug.time = function (name) {
  Webr.component.Debug.consoleMethod("time", name);
};
Webr.component.Debug.timeEnd = function (name) {
  Webr.component.Debug.consoleMethod("timeEnd", name);
};
Webr.component.Debug.profile = function (title) {
  Webr.component.Debug.consoleMethod("profile");
};
Webr.component.Debug.profileEnd = function () {
  Webr.component.Debug.consoleMethod("profileEnd");
};
Webr.component.Debug.group = function (message) {
  Webr.component.Debug.consoleMethod("group");
};
Webr.component.Debug.groupEnd = function () {
  Webr.component.Debug.consoleMethod("groupEnd");
};
Webr.component.Debug.dumpStackTrace = function () {
  Webr.component.Debug.group("Stack trace");
  var f = arguments.callee;
  if (f) {
    f = f.caller;
    while (f) {
      Webr.component.Debug.info(f.toString());
      f = f.caller;
    }

  }

  Webr.component.Debug.groupEnd();
};
Webr.component.Debug.consoleMethod = function (method, param) {
  if (Webr.component.Debug.DEBUG && (window["console"] && window["console"][method])) {
    window["console"][method](param);
  }

};
var info = Webr.component.Debug.info;
var trace = Webr.component.Debug.trace;
var time = Webr.component.Debug.time;
var timeEnd = Webr.component.Debug.timeEnd;
var profile = Webr.component.Debug.profile;
var profileEnd = Webr.component.Debug.profileEnd;
