Webr.component.Menu = function (button, openOnClick, openLeft) {
  this.enabled = true;
  this.shadow = null;
  this.selected = -1;
  this.showPause = 100;
  this.hidePause = 10;
  this.current_state = null;
  this.button = $(button);
  this.openLeft = openLeft;
  this.button.data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE, this);
  if (this.button.parent("td").length > 0) {
    this.anchor = this.button.parent("td");
    this.activeClass = "jt-toolbar-menu-active";
  } else {
    this.anchor = this.button;
    this.activeClass = "jt-menu-active";
  }

  this.list = this.button.next("ul");
  this.fixListWidth();
  this.shadow = Webr.component.Shadow.getShadow(this.list, "jt-menu-ieshadow");
  this.initEvents(openOnClick);
  this.createListAnchors();
  this.current_state = Webr.component.Menu.state_CLOSED;
};
Webr.component.Menu.prototype.mouseOverButton = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mouseOverButton", arguments);
};
Webr.component.Menu.prototype.mouseOverList = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mouseOverList", arguments);
};
Webr.component.Menu.prototype.mouseOutButton = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mouseOutButton", arguments);
};
Webr.component.Menu.prototype.mouseOutList = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mouseOutList", arguments);
};
Webr.component.Menu.prototype.mouseDownList = function (event) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mouseDownList", arguments);
};
Webr.component.Menu.prototype.listClick = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "listClick", arguments);
};
Webr.component.Menu.prototype.buttonClick = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "buttonClick", arguments);
};
Webr.component.Menu.prototype.tick = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "tick", arguments);
};
Webr.component.Menu.prototype.hide = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "hide", arguments);
};
Webr.component.Menu.prototype.enable = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "enable", arguments);
};
Webr.component.Menu.prototype.disable = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "disable", arguments);
};
Webr.component.Menu.prototype.initEvents = function (openOnClick) {
  var t = this;
  //unbind mouseover & click from registration if any
  this.anchor.unbind("mouseover").unbind("click");
  //bind
  if (!openOnClick) {
    this.anchor.mouseover(function () {
      t.mouseOverButton();
    });
  }

  this.list.mouseover(function () {
    t.mouseOverList();
  });
  if (!openOnClick) {
    this.anchor.mouseout(function () {
      t.mouseOutButton();
    });
  }

  this.anchor.click(function () {
    t.buttonClick();
  });
  if (!openOnClick) {
    this.list.mouseout(function () {
      t.mouseOutList();
    });
  }

  this.list.click(function () {
    t.listClick();
  });
  this.mouseDownHandler = function (event) {
    return t.mouseDownList(event);
  };
  //key handler
  this.keyHandler = function (event) {
    if (event.isKey(Webr.util.Key.UP)) {
      t._prev();
      return false;
    }

    if (event.isKey(Webr.util.Key.DOWN)) {
      t._next();
      return false;
    }

    if (event.isKey(Webr.util.Key.ESC)) {
      t.hide();
      return false;
    }

    if (event.isKey(Webr.util.Key.HOME)) {
      t._home();
      return false;
    }

    if (event.isKey(Webr.util.Key.END)) {
      t._end();
      return false;
    }

  };
};
Webr.component.Menu.prototype.createListAnchors = function () {
  this.items = this.list.find("a");
  this.registerItemsEvents();
};
Webr.component.Menu.prototype.handleBlur = function () {
  var d = $(Webr.util.Util.isIE ?document.body :document);
  d.mousedown(this.mouseDownHandler);
};
Webr.component.Menu.prototype.unhandleBlur = function () {
  var d = $(Webr.util.Util.isIE ?document.body :document);
  d.unbind("mousedown", this.mouseDownHandler);
};
Webr.component.Menu.prototype.registerItemsEvents = function () {
  var t = this;
  this.items.mouseover(function (event) {
    var index = t.items.index(event.target);
    if (index != t.selected) {
      var selected = t.getSelected();
      if (selected) {
        t.toggleCssClass(selected);
      }

      t.selected = index;
      t.select(index, true);
    }

  });
};
Webr.component.Menu.prototype.handleKeys = function () {
  this.list.keydown(this.keyHandler);
  var selected = this.items.first();
  this.toggleCssClass(selected);
  selected.focus();
  this.selected = 0;
};
Webr.component.Menu.prototype.unhandleKeys = function () {
  this.list.unbind("keydown");
  if (this.selected >= 0) {
    this.toggleCssClass(this.getSelected());
    this.selected = -1;
  }

};
Webr.component.Menu.prototype._home = function () {
  var selected = this.getSelected();
  if (selected && this.selected != 0) {
    this.unselect(selected);
    this.select(0, true);
  }

};
Webr.component.Menu.prototype._end = function () {
  var selected = this.getSelected();
  var size = this.size() - 1;
  if (selected && this.selected != size) {
    this.unselect(selected);
    this.select(size, true);
  }

};
Webr.component.Menu.prototype._prev = function () {
  var selected = this.getSelected();
  if (selected && this.selected >= 1) {
    this.unselect(selected);
    this.select(-1, false);
  }

};
Webr.component.Menu.prototype._next = function () {
  var selected = this.getSelected();
  if (selected && this.selected < this.size() - 1) {
    this.unselect(selected);
    this.select(1, false);
  }

};
Webr.component.Menu.prototype.select = function (pos, Index) {
  var index = Index ?pos :this.selected + pos;
  if (index >= 0 && index < this.size()) {
    this.selected = index;
    var selected = this.items.eq(this.selected);
    this.toggleCssClass(selected);
    selected.focus();
  }

};
Webr.component.Menu.prototype.unselect = function (selected) {
  this.toggleCssClass(selected);
  selected.blur();
};
Webr.component.Menu.prototype.getSelected = function () {
  if (this.size() <= 0 || this.selected == -1) {
    return null;
  }

  return this.items.eq(this.selected);
};
Webr.component.Menu.prototype.toggleCssClass = function (el) {
  if (el) {
    el.toggleClass("jt-menu-item-active");
  }

};
Webr.component.Menu.prototype.setEnabled = function (enabled) {
  if (enabled) {
    this.enable();
  } else {
    this.disable();
  }

};
Webr.component.Menu.prototype.isEnabled = function () {
  return this.enabled;
};
Webr.component.Menu.prototype.size = function () {
  return this.items.length;
};
Webr.component.Menu.prototype.fixListWidth = function () {
  if (this.anchor.outerWidth() > this.list.outerWidth()) {
    var delta = this.list.outerWidth() - this.list.width();
    this.list.css("min-width", this.anchor.outerWidth() - delta);
  }

};
Webr.component.Menu.prototype._show = function () {
  if (Webr.component.Menu.OPEN_MENU) {
    Webr.component.Menu.OPEN_MENU.hide();
  }

  Webr.component.Menu.OPEN_MENU = this;
  this.anchor.addClass(this.activeClass);
  this.setItemsPosition();
  this.list.show();
  this.handleKeys();
  this.shadow.setHeight(this.list.outerHeight());
  this.shadow.show();
};
Webr.component.Menu.prototype.setItemsPosition = function () {
  var pos = this.anchor.position();
  var menuWidth = this.list.outerWidth();
  var top = pos.top + this.anchor.outerHeight();
  var left;
  if (this.openLeft || ($(window).width() < pos.left + menuWidth)) {
    var l = Math.ceil(pos.left - menuWidth + this.anchor.outerWidth());
    left = l > 0 ?l :pos.left;
  } else {
    left = pos.left;
  }

  this.list.css({top: top, left: left});
  this.shadow.setTop(top);
  this.shadow.setLeft(left);
};
Webr.component.Menu.prototype._hide = function () {
  Webr.component.Menu.OPEN_MENU = null;
  this.unhandleKeys();
  this.list.hide();
  this.shadow.hide();
  this.anchor.removeClass(this.activeClass);
};
Webr.component.Menu.prototype._setEnabled = function (enabled) {
  this.enabled = enabled;
  if (enabled) {
    this.button.removeClass("jt-menu-disabled");
  } else {
    this.button.addClass("jt-menu-disabled");
  }

};
Webr.component.Menu.prototype._startShowTimer = function () {
  var t = this;
  this.showTimerHandler = window.setTimeout(function () {
    t.tick();
  }, this.showPause);
};
Webr.component.Menu.prototype._stopShowTimer = function () {
  window.clearTimeout(this.showTimerHandler);
};
Webr.component.Menu.prototype._startHideTimer = function () {
  var t = this;
  this.hideTimerHandler = window.setTimeout(function () {
    t.tick();
  }, this.hidePause);
};
Webr.component.Menu.prototype._stopHideTimer = function () {
  window.clearTimeout(this.hideTimerHandler);
};
Webr.component.Menu.state_CLOSED = {name: "CLOSED", mouseOverButton: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_PAUSE_BEFORE_OPEN);
    }

    return Webr.component.Menu.state_PAUSE_BEFORE_OPEN;
  }

  return false;
}, buttonClick: function () {
  if (true) {
    this._show();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_OPEN);
    }

    return Webr.component.Menu.state_OPEN;
  }

  return false;
}, disable: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_DISABLED);
    }

    return Webr.component.Menu.state_DISABLED;
  }

  return false;
}};
Webr.component.Menu.state_PAUSE_BEFORE_OPEN = {name: "PAUSE_BEFORE_OPEN", onenter: function () {
  this._startShowTimer();
}, onexit: function () {
  this._stopShowTimer();
}, tick: function () {
  if (true) {
    this._show();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_OPEN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_OPEN);
    }

    return Webr.component.Menu.state_OPEN;
  }

  return false;
}, buttonClick: function () {
  if (true) {
    this._show();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_OPEN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_OPEN);
    }

    return Webr.component.Menu.state_OPEN;
  }

  return false;
}, mouseOutButton: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_OPEN);
    }

    return Webr.component.Menu.state_CLOSED;
  }

  return false;
}, mouseOutList: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_OPEN);
    }

    return Webr.component.Menu.state_CLOSED;
  }

  return false;
}};
Webr.component.Menu.state_OPEN = {name: "OPEN", onenter: function () {
  this.handleBlur();
}, onexit: function () {
  this.unhandleBlur();
}, mouseOutButton: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_OPEN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_PAUSE_BEFORE_CLOSE);
    }

    return Webr.component.Menu.state_PAUSE_BEFORE_CLOSE;
  }

  return false;
}, mouseOutList: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_OPEN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_PAUSE_BEFORE_CLOSE);
    }

    return Webr.component.Menu.state_PAUSE_BEFORE_CLOSE;
  }

  return false;
}, hide: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_OPEN);
    }

    return Webr.component.Menu.state_CLOSED;
  }

  return false;
}, listClick: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_OPEN);
    }

    return Webr.component.Menu.state_CLOSED;
  }

  return false;
}, disable: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_OPEN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_DISABLED);
    }

    return Webr.component.Menu.state_DISABLED;
  }

  return false;
}, mouseDownList: function (event) {
  if (true) {
    if (!(this.list.ancestorOf(event.target)) && !this.anchor.ancestorOf(event.target, true)) {
      this.mouseOutList();
    }

    return ;
  }

  return false;
}, buttonClick: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_OPEN);
    }

    return Webr.component.Menu.state_CLOSED;
  }

  return false;
}};
Webr.component.Menu.state_PAUSE_BEFORE_CLOSE = {name: "PAUSE_BEFORE_CLOSE", onenter: function () {
  this._startHideTimer();
}, onexit: function () {
  this._stopHideTimer();
}, tick: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_CLOSE);
    }

    return Webr.component.Menu.state_CLOSED;
  }

  return false;
}, hide: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_CLOSE);
    }

    return Webr.component.Menu.state_CLOSED;
  }

  return false;
}, listClick: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_CLOSE);
    }

    return Webr.component.Menu.state_CLOSED;
  }

  return false;
}, mouseOverButton: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_CLOSE);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_OPEN);
    }

    return Webr.component.Menu.state_OPEN;
  }

  return false;
}, mouseOverList: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_CLOSE);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_OPEN);
    }

    return Webr.component.Menu.state_OPEN;
  }

  return false;
}, disable: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_PAUSE_BEFORE_CLOSE);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.Menu.state_DISABLED);
    }

    return Webr.component.Menu.state_DISABLED;
  }

  return false;
}};
Webr.component.Menu.state_DISABLED = {name: "DISABLED", onenter: function () {
  this._setEnabled(false);
}, onexit: function () {
  this._setEnabled(true);
}, enable: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.Menu.state_DISABLED);
    }

    return Webr.component.Menu.state_CLOSED;
  }

  return false;
}};
Webr.component.Menu.registerMenu = function (path, comboboxSuffixName) {
  cr.forEach(path, comboboxSuffixName, function () {
    var button = $(this);
    var handler = button;
    if (button.parent("td").length > 0) {
      handler = button.parent("td");
    }

    var openOnClick = button.data("toggle-onclick");
    handler.one(openOnClick ?"click" :"mouseover", function () {
      new Webr.component.Menu(button, openOnClick, button.data("open-left"))[openOnClick ?"buttonClick" :"mouseOverButton"]();
    });
  });
};
Webr.component.Menu.getMenu = function (menu, toggleOnclick, openLeft) {
  if (menu._startShowTimer) {
    return menu;
  } else {
    //remove mouseover handler from registerMenu
    return new Webr.component.Menu(menu, toggleOnclick, openLeft);
  }

};
var regmn = Webr.component.Menu.registerMenu;
