/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.javascript.runtime.jsDependencies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.ClasspathUrlGetter;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.JsDependency;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class JsDependencyAggregator
implements ApplicationContextAware {
    protected static Log log = LogFactory.getLog(JsDependencyAggregator.class);
    private ApplicationContext context;
    private String myWildcard;
    private String myFqNamePrefix;
    private String myRelativePathPrefix;

    public List<JsDependency> getDependencies() {
        IListSequence dependencies;
        block3: {
            dependencies = ListSequence.fromList(new ArrayList());
            try {
                Resource[] resources;
                for (Resource resource : resources = this.context.getResources(this.getWildcard())) {
                    JsDependency jsDependency = new JsDependency();
                    String filename = resource.getFilename();
                    String fqName = this.getFqNamePrefix() + "." + filename.substring(0, filename.length() - 3);
                    ClasspathUrlGetter urlGetter = new ClasspathUrlGetter();
                    urlGetter.setResourcePath(this.getRelativePathPrefix() + "/" + filename);
                    jsDependency.setName(fqName);
                    jsDependency.setUrlGetter(urlGetter);
                    jsDependency.setRunTimeDeps((List<String>)ListSequence.fromList(new ArrayList()));
                    jsDependency.setCompileTimeDeps((List<String>)ListSequence.fromList(new ArrayList()));
                    ListSequence.fromList((List)dependencies).addElement((Object)jsDependency);
                }
            }
            catch (IOException exception) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't load aggregated dependencies", (Throwable)exception);
            }
        }
        return dependencies;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    public String getWildcard() {
        return this.myWildcard;
    }

    public void setWildcard(String value) {
        this.myWildcard = value;
    }

    public String getFqNamePrefix() {
        return this.myFqNamePrefix;
    }

    public void setFqNamePrefix(String value) {
        this.myFqNamePrefix = value;
    }

    public String getRelativePathPrefix() {
        return this.myRelativePathPrefix;
    }

    public void setRelativePathPrefix(String value) {
        this.myRelativePathPrefix = value;
    }
}

