/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.rpc.rest.filter.runtime;

import com.jetbrains.teamsys.dnq.database.TransientStoreUtil;
import java.io.Closeable;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.ContainerRequest;

public class TransactionalResourceFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String SESSION_KEY = TransactionalResourceFilter.class.getCanonicalName() + ".STORE_SESSION";
    protected static Log log = LogFactory.getLog(TransactionalResourceFilter.class);
    protected final CloseableService closeableService;

    public TransactionalResourceFilter(@Context CloseableService closeableService) {
        this.closeableService = closeableService;
    }

    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    public ContainerResponseFilter getResponseFilter() {
        return this;
    }

    public void filter(ContainerRequestContext context) {
        TransientStoreSession session = DnqUtils.getCurrentTransientSession();
        if (session != null) {
            TransientStoreUtil.abort((TransientStoreSession)session);
        }
        session = this.beginTransaction();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Begin rest transaction");
        }
        context.setProperty(SESSION_KEY, (Object)session);
        this.closeableService.add((Closeable)new CloseableTransactionWrapper(session));
    }

    protected TransientStoreSession beginTransaction() {
        return DnqUtils.beginTransientSession();
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        TransientStoreSession session = (TransientStoreSession)request.getProperty(SESSION_KEY);
        if (session != null) {
            if (this.isRevertRequiered(request, response)) {
                session.revert();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Revert rest transaction");
                }
            } else {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Commit rest transaction");
                    }
                    while (session.hasChanges()) {
                        session.flush();
                    }
                }
                catch (RuntimeException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Can't commit rest transaction", (Throwable)e);
                    }
                    throw e;
                }
            }
        }
    }

    protected boolean isRevertRequiered(ContainerRequestContext request, ContainerResponseContext response) {
        return response.getStatusInfo().getStatusCode() >= 400;
    }

    public static void abortSession(ContainerRequest request) {
        TransientStoreSession session = (TransientStoreSession)request.getProperty(SESSION_KEY);
        session.abort();
        request.setProperty(SESSION_KEY, null);
    }

    public static class CloseableTransactionWrapper
    implements Closeable {
        private final TransientStoreSession transaction;

        public CloseableTransactionWrapper(TransientStoreSession transaction) {
            this.transaction = transaction;
        }

        @Override
        public void close() throws IOException {
            if (this.transaction.isOpened()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Abort rest transaction from failsafe wrapper");
                }
                this.transaction.abort();
            }
        }
    }
}

