/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.rpc.rest.provider.filter;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.jersey.message.MessageBodyWorkers;

public class CharsetResponseFilter
implements ContainerResponseFilter {
    private static final String CONTENT_TYPE_HEADER = "Content-type";
    private static final String CHARSET_PARAMETER = "charset";
    private static final String APPLICATION_TYPE_NAME = "application";
    private static final String JSON_SUBTYPE_NAME = "json";
    private static final String XML_SUBTYPE_NAME = "xml";
    private static final String TEXT_TYPE_NAME = "text";
    protected static Log log = LogFactory.getLog(CharsetResponseFilter.class);
    @Context
    private MessageBodyWorkers workers;

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        if (response.getEntity() == null) {
            return;
        }
        MediaType mediaType = response.getMediaType();
        if (mediaType == null) {
            mediaType = this.workers.getMessageBodyWriterMediaType(response.getEntity().getClass(), response.getEntityType(), response.getEntityAnnotations(), request.getAcceptableMediaTypes());
        }
        if (mediaType == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unknown response media type: " + request.getUriInfo().toString()));
            }
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        Map params = mediaType.getParameters();
        String type = mediaType.getType();
        String subtype = mediaType.getSubtype();
        if (!params.containsKey(CHARSET_PARAMETER) && (type.equals(APPLICATION_TYPE_NAME) && (subtype.equals(JSON_SUBTYPE_NAME) || subtype.equals(XML_SUBTYPE_NAME)) || type.equals(TEXT_TYPE_NAME))) {
            HashMap<String, String> newParams = new HashMap<String, String>(params);
            newParams.put(CHARSET_PARAMETER, "utf-8");
            mediaType = new MediaType(type, subtype, newParams);
        }
        response.getHeaders().putSingle((Object)CONTENT_TYPE_HEADER, (Object)mediaType);
    }
}

