/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.rpc.rest.provider.misc;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ExceptionMapper;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.rpc.rest.provider.exception.ExceptionMapperContainer;
import jetbrains.mps.webr.rpc.rest.provider.misc.EmptyServletContext;
import jetbrains.mps.webr.rpc.rest.runtime.Provider;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.runtime.requestProcessor.RestHandler;
import jetbrains.mps.webr.runtime.url.RequestUri;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.WebComponent;
import org.glassfish.jersey.servlet.WebConfig;
import org.glassfish.jersey.uri.UriComponent;
import org.springframework.beans.factory.InitializingBean;
import webr.framework.controller.BaseApplication;

public class DefaultRestRequestHandler
implements RestHandler,
InitializingBean {
    protected static Log log = LogFactory.getLog(DefaultRestRequestHandler.class);
    private WebComponent webComponent;
    private boolean disabled = false;
    private Set<Object> singletons = SetSequence.fromSet(new LinkedHashSet(1));
    private List<ContainerRequestFilter> myRequestFilters;
    private List<ContainerResponseFilter> myResponseFilters;

    protected WebComponent init() throws ServletException {
        ResourceConfig rc = new ResourceConfig();
        for (Object singleton_var : SetSequence.fromSet(this.singletons)) {
            rc.register(singleton_var);
        }
        rc.register(JacksonFeature.class);
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("jersey.config.server.wadl.disableWadl", true);
        rc.addProperties(properties);
        if (log.isInfoEnabled()) {
            log.info((Object)("REST request filters:\n" + IterableUtils.join((Iterable)ListSequence.fromList(this.getRequestFilters()).select((_FunctionTypes._return_P1_E0)new ISelector<ContainerRequestFilter, String>(){

                public String select(ContainerRequestFilter it) {
                    return it.getClass().getName();
                }
            }), (String)"\n")));
        }
        for (ContainerRequestFilter filter_var : ListSequence.fromList(this.getRequestFilters())) {
            rc.register((Object)filter_var);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("REST response filters:\n" + IterableUtils.join((Iterable)ListSequence.fromList(this.getResponseFilters()).select((_FunctionTypes._return_P1_E0)new ISelector<ContainerResponseFilter, String>(){

                public String select(ContainerResponseFilter it) {
                    return it.getClass().getName();
                }
            }), (String)"\n")));
        }
        for (ContainerRequestFilter filter_var : ListSequence.fromList(this.getResponseFilters())) {
            rc.register((Object)filter_var);
        }
        return new WebComponent((WebConfig)new RestWebConfig(), rc);
    }

    public void afterPropertiesSet() throws Exception {
        this.webComponent = this.disabled ? null : this.init();
    }

    public void setProviders(List<Provider> providers) {
        if (log.isInfoEnabled()) {
            log.info((Object)("REST providers:\n" + IterableUtils.join((Iterable)ListSequence.fromList(providers).select((_FunctionTypes._return_P1_E0)new ISelector<Provider, String>(){

                public String select(Provider it) {
                    return it.getClass().getName();
                }
            }), (String)"\n")));
        }
        SetSequence.fromSet(this.singletons).addSequence((ISequence)ListSequence.fromList(providers));
    }

    public void setResources(List<Resource> resources) {
        if (ListSequence.fromList(resources).isEmpty()) {
            this.disabled = true;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("REST resources:\n" + IterableUtils.join((Iterable)ListSequence.fromList(resources).select((_FunctionTypes._return_P1_E0)new ISelector<Resource, String>(){

                    public String select(Resource it) {
                        return it.getClass().getName();
                    }
                }), (String)"\n")));
            }
            SetSequence.fromSet(this.singletons).addSequence((ISequence)ListSequence.fromList(resources));
        }
    }

    public void setExceptionMapperContainer(ExceptionMapperContainer container) {
        Map<Class, ExceptionMapper> mappers = container.getMappers();
        if (log.isInfoEnabled()) {
            log.info((Object)("REST exception mappers:\n" + IterableUtils.join((Iterable)MapSequence.fromMap(mappers).select((_FunctionTypes._return_P1_E0)new ISelector<IMapping<Class, ExceptionMapper>, String>(){

                public String select(IMapping<Class, ExceptionMapper> it) {
                    return ((Class)it.key()).getSimpleName() + " -> " + ((ExceptionMapper)it.value()).getClass().getName();
                }
            }), (String)"\n")));
        }
        SetSequence.fromSet(this.singletons).addSequence(Sequence.fromIterable((Iterable)MapSequence.fromMap(mappers).values()));
    }

    public int handle(RequestUri request) {
        if (this.disabled) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"REST disabled. No resources found. All requests are skipped.");
            }
            return -1;
        }
        try {
            String encodedBasePath;
            HttpServletRequest servletRequest = BaseApplication.getRequest();
            HttpServletResponse servletResponse = BaseApplication.getResponse();
            URI baseUri = null;
            URI requestUri = null;
            StringBuffer requestURL = servletRequest.getRequestURL();
            String requestURI = servletRequest.getRequestURI();
            if (!servletRequest.getRequestURI().endsWith("/")) {
                requestURL.append("/");
                requestURI = requestURI + "/";
            }
            UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)URLEncoder.encode(requestURL.toString(), StandardCharsets.UTF_8.toString()));
            String decodedBasePath = BaseApplication.getFullContextPath() + "/rest/";
            if (!decodedBasePath.equals(encodedBasePath = UriComponent.encode((String)decodedBasePath, (UriComponent.Type)UriComponent.Type.PATH))) {
                throw new ContainerException("The servlet context path and/or the servlet path contain characters that are percent encoded");
            }
            baseUri = absoluteUriBuilder.replacePath(encodedBasePath).build(new Object[0]);
            StringBuilder builder = new StringBuilder();
            Enumeration e = servletRequest.getParameterNames();
            boolean first = true;
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] values = servletRequest.getParameterValues(name);
                if (values == null) continue;
                for (String v : values) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append('&');
                    }
                    builder.append(name).append('=').append(URLEncoder.encode(v, StandardCharsets.UTF_8.toString()));
                }
            }
            String queryParameters = builder.toString();
            try {
                requestUri = absoluteUriBuilder.replacePath(requestURI).replaceQuery(queryParameters).build(new Object[0]);
            }
            catch (IllegalArgumentException iae) {
                throw new BadRequestException(iae.getMessage(), (Throwable)iae);
            }
            return (Integer)this.webComponent.service(baseUri, requestUri, servletRequest, servletResponse).get();
        }
        catch (Exception e) {
            if (e instanceof ClientErrorException) {
                throw (ClientErrorException)e;
            }
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while rest request processing", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    private List<ContainerRequestFilter> getRequestFilters() {
        return this.myRequestFilters;
    }

    public void setRequestFilters(List<ContainerRequestFilter> value) {
        this.myRequestFilters = value;
    }

    private List<ContainerResponseFilter> getResponseFilters() {
        return this.myResponseFilters;
    }

    public void setResponseFilters(List<ContainerResponseFilter> value) {
        this.myResponseFilters = value;
    }

    private static void copyCommonsLogLevelToJavaLoggerLevel(String name) {
        Logger logger = Logger.getLogger(name);
        if (logger != null) {
            Log commonsLog = LogFactory.getLog((String)name);
            if (commonsLog.isTraceEnabled()) {
                logger.setLevel(Level.ALL);
            } else if (commonsLog.isDebugEnabled()) {
                logger.setLevel(Level.FINER);
            } else if (commonsLog.isInfoEnabled()) {
                logger.setLevel(Level.INFO);
            } else if (commonsLog.isWarnEnabled()) {
                logger.setLevel(Level.WARNING);
            } else if (commonsLog.isErrorEnabled()) {
                logger.setLevel(Level.SEVERE);
            } else if (commonsLog.isFatalEnabled()) {
                logger.setLevel(Level.SEVERE);
            } else {
                logger.setLevel(Level.OFF);
            }
        }
    }

    public class RestServletConfig
    implements ServletConfig {
        public String getServletName() {
            return "oldRestServlet";
        }

        public ServletContext getServletContext() {
            return BaseApplication.getServletContext();
        }

        public String getInitParameter(String string) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.emptyEnumeration();
        }
    }

    private class RestWebConfig
    implements WebConfig {
        private ServletConfig config;

        private RestWebConfig() {
            this.config = new RestServletConfig();
        }

        public WebConfig.ConfigType getConfigType() {
            return WebConfig.ConfigType.ServletConfig;
        }

        public String getName() {
            return this.getServletContext().getServletContextName();
        }

        public String getInitParameter(String param) {
            return this.getServletContext().getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return this.getServletContext().getInitParameterNames();
        }

        public ServletContext getServletContext() {
            ServletContext result = BaseApplication.getServletContext();
            if (result == null) {
                return new EmptyServletContext();
            }
            return result;
        }

        public FilterConfig getFilterConfig() {
            return null;
        }

        public ServletConfig getServletConfig() {
            return this.config;
        }
    }
}

