/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.cache;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;

public class CacheControlUtil {
    private static long SECONDS_IN_ONE_YEAR = 31536000L;
    private static long MILLIS_IN_ONE_YEAR = SECONDS_IN_ONE_YEAR * 1000L;
    private static String FORMAT_PATTERN = "EEE, dd MMM yyyy hh:mm:ss z";

    private CacheControlUtil() {
    }

    private static void setCacheableHeaders(HttpServletResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_PATTERN, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        response.setHeader("Expires", dateFormatter.format(new Date(System.currentTimeMillis() + MILLIS_IN_ONE_YEAR)));
        response.setHeader("Cache-Control", "max-age=" + SECONDS_IN_ONE_YEAR);
    }

    public static void setNonCacheableHeaders(HttpServletResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_PATTERN, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        response.setHeader("Expires", dateFormatter.format(new Date(System.currentTimeMillis() - MILLIS_IN_ONE_YEAR)));
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
    }

    public static void setHeaders(HttpServletResponse response, boolean isCacheable) {
        if (isCacheable) {
            CacheControlUtil.setCacheableHeaders(response);
        } else {
            CacheControlUtil.setNonCacheableHeaders(response);
        }
    }
}

