/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.converter;

import jetbrains.mps.webr.runtime.converter.FixedClassConverter;
import jetbrains.mps.webr.runtime.converter.LocalizedWrongFormatException;
import jetbrains.mps.webr.runtime.converter.NullConvertException;

public class ShortConverter
extends FixedClassConverter {
    public ShortConverter() {
        super(Short.TYPE);
    }

    @Override
    public String toString(Object value) {
        return this.doToString((Short)value);
    }

    private String doToString(short value) {
        return String.valueOf(value);
    }

    @Override
    public Object fromString(String typeName, String valueAsString) {
        if (valueAsString == null) {
            throw new NullConvertException(typeName);
        }
        try {
            return Short.parseShort(valueAsString);
        }
        catch (NumberFormatException e) {
            throw new LocalizedWrongFormatException(typeName, "jetbrains.webr_dnq.short_converter_format_exception", valueAsString);
        }
    }
}

