/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.freemarker;

import freemarker.template.TemplateModelException;
import java.util.LinkedList;
import java.util.List;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.freemarker.FreemarkerMethod;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class LocalizeMessage
implements FreemarkerMethod {
    @Override
    public String getMethodName() {
        return "l10n";
    }

    public Object exec(List arguments) throws TemplateModelException {
        String msg;
        if (arguments == null || arguments.size() < 1) {
            throw new IllegalArgumentException("Message key is required");
        }
        String key = (String)arguments.get(0);
        Localizer localizer = (Localizer)ServiceLocator.getOptionalBean((String)"localizer");
        if (arguments.size() > 1) {
            arguments = new LinkedList(arguments);
            arguments.remove(0);
            msg = localizer.localizedMsg(key, new Object[]{arguments});
        } else {
            msg = localizer.localizedMsg(key, new Object[0]);
        }
        return msg.replaceAll("\\\"", "\\\\\"").replaceAll("\\'", "\\\\'");
    }
}

