/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.listeners;

import java.util.HashMap;
import java.util.Map;
import jetbrains.exodus.database.IEntityListener;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityAdapter;
import jetbrains.exodus.entitystore.EventsMultiplexer;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.runtime.listeners.EventsMultiplexerProxy;
import jetbrains.mps.webr.runtime.listeners.LocalEventsMultiplexerProxy;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.eventsCompat.EventsMultiplexerLegacy;

public class EventsMultiplexerProxyImpl
implements EventsMultiplexerProxy {
    private final Map<String, ListenerDelegate> typeToListeners = new HashMap<String, ListenerDelegate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(String entityType, IEntityListener listener) {
        Map<String, ListenerDelegate> map = this.typeToListeners;
        synchronized (map) {
            ListenerDelegate delegate = this.typeToListeners.get(entityType);
            if (delegate == null) {
                this.typeToListeners.put(entityType, new ListenerDelegate(entityType));
            }
        }
        ((LocalEventsMultiplexerProxy)ServiceLocator.getBean((String)"localEventsMultiplexerProxy")).addListener(entityType, listener);
    }

    @Override
    public void removeListener(String entityType, IEntityListener listener) {
        ((LocalEventsMultiplexerProxy)ServiceLocator.getBean((String)"localEventsMultiplexerProxy")).removeListener(entityType, listener);
    }

    public void uninstall() {
        EventsMultiplexer eventsMultiplexer = EventsMultiplexerLegacy.getInstance();
        if (eventsMultiplexer != null) {
            for (String entityType : this.typeToListeners.keySet()) {
                eventsMultiplexer.removeListener(entityType, (IEntityListener)this.typeToListeners.get(entityType));
            }
        }
    }

    private final class ListenerDelegate
    extends EntityAdapter {
        private final String entityType;

        public ListenerDelegate(String entityType) {
            this.entityType = entityType;
            EventsMultiplexerLegacy.getInstance().addListener(entityType, (IEntityListener)this);
        }

        public void uninstall(String entityType) {
            EventsMultiplexerLegacy.getInstance().removeListener(entityType, (IEntityListener)this);
        }

        public void addedAsync(final Entity added) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.addedAsync(added);
                }
            });
        }

        public void updatedAsync(final Entity old, final Entity current) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.updatedAsync(old, current);
                }
            });
        }

        public void removedAsync(final Entity removed) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.removedAsync(removed);
                }
            });
        }

        public void addedSync(final Entity added) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.addedSync(added);
                }
            });
        }

        public void addedSyncBeforeConstraints(final Entity added) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.addedSyncBeforeConstraints(added);
                }
            });
        }

        public void addedSyncAfterConstraints(final Entity added) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.addedSyncAfterConstraints(added);
                }
            });
        }

        public void updatedSync(final Entity old, final Entity current) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.updatedSync(old, current);
                }
            });
        }

        public void updatedSyncBeforeConstraints(final Entity old, final Entity current) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.updatedSyncBeforeConstraints(old, current);
                }
            });
        }

        public void updatedSyncAfterConstraints(final Entity old, final Entity current) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.updatedSyncAfterConstraints(old, current);
                }
            });
        }

        public void removedSync(final Entity removed) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.removedSync(removed);
                }
            });
        }

        public void removedSyncBeforeConstraints(final Entity removed) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.removedSyncBeforeConstraints(removed);
                }
            });
        }

        public void removedSyncAfterConstraints(final Entity removed) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.removedSyncAfterConstraints(removed);
                }
            });
        }

        public void addedSyncBeforeFlush(final Entity added) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.addedSyncBeforeFlush(added);
                }
            });
        }

        public void updatedSyncBeforeFlush(final Entity old, final Entity current) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.updatedSyncBeforeFlush(old, current);
                }
            });
        }

        public void removedSyncBeforeFlush(final Entity removed) {
            this.delegate((_FunctionTypes._void_P1_E0<? super IEntityListener>)new _FunctionTypes._void_P1_E0<IEntityListener>(){

                public void invoke(IEntityListener listener) {
                    listener.removedSyncBeforeFlush(removed);
                }
            });
        }

        private void delegate(_FunctionTypes._void_P1_E0<? super IEntityListener> fire) {
            Iterable<IEntityListener> listeners = ((LocalEventsMultiplexerProxy)ServiceLocator.getBean((String)"localEventsMultiplexerProxy")).getListeners(this.entityType);
            if (listeners != null) {
                for (IEntityListener listener : listeners) {
                    fire.invoke((Object)listener);
                }
            }
        }
    }
}

