/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jetbrains.mps.webr.runtime.requestProcessor.FileUploadParams;
import jetbrains.mps.webr.runtime.url.RequestUri;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.ErrorMessageManager;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;

public class FileUploadRequestProcessor
implements RequestProcessor {
    private static String FILE_ITEM_STREAMS = "FILE_ITEM_STREAMS";
    protected static Log log = LogFactory.getLog(FileUploadRequestProcessor.class);
    private Map<RequestProcessor, String> dependentRequestProcessors;

    @Override
    public boolean isApplicable(RequestUri requestUri) {
        String controller = requestUri.getElement(0);
        HttpServletRequest request = BaseApplication.getRequest();
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    @Override
    public Map<RequestProcessor, String> getDependentRequestProcessors() {
        return this.dependentRequestProcessors;
    }

    public void setDependentRequestProcessors(Map<RequestProcessor, String> precedingRequestProcessors) {
        this.dependentRequestProcessors = precedingRequestProcessors;
    }

    @Override
    public ResponseAction processRequest(RequestUri requestUri) {
        ResponseAction responseAction = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request is multipart. Upload files.");
        }
        HttpServletRequest request = BaseApplication.getRequest();
        FileUploadParams params = (FileUploadParams)ServiceLocator.getBean((String)"fileUploadParams");
        params.initTempFolder();
        DiskFileItemFactory factory = new DiskFileItemFactory(params.getThresholdSize(), params.getTempFolder());
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding(StandardCharsets.UTF_8.toString());
        upload.setSizeMax(params.getMaxFileUploadSize());
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        HashMap<String, List<DiskFileItem>> files = new HashMap<String, List<DiskFileItem>>();
        try {
            for (FileItem fileItem : upload.parseRequest(request)) {
                String fieldName = fileItem.getFieldName();
                if (fileItem.isFormField()) {
                    try {
                        String value = fileItem.getString(StandardCharsets.UTF_8.toString());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found form field: " + fieldName + "=" + value));
                        }
                        FileUploadRequestProcessor.addParameterValue(parameters, fieldName, value);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)"Can't get value of form field", (Throwable)e);
                    }
                    continue;
                }
                String itemName = fileItem.getName();
                if (itemName == null || itemName.length() == 0) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Skip file with enpty name. Form field: " + fieldName));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Upload file: " + itemName + "=" + fileItem.getContentType()));
                }
                FileUploadRequestProcessor.addFileValue(files, fieldName, (DiskFileItem)fileItem);
            }
        }
        catch (FileUploadException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while uploading file", (Throwable)e);
            }
            ErrorMessageManager.addMessage((Serializable)((Object)e.getLocalizedMessage()), ErrorMessageManager.Severity.ERROR, null);
        }
        request.setAttribute(FILE_ITEM_STREAMS, files);
        BaseApplication.setRequest((HttpServletRequest)new MultipartRequestWrapper(request, parameters));
        return responseAction;
    }

    public void setTempFolder(String tempFolder) {
        File file = new File(tempFolder);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("[" + tempFolder + "] should be directory.");
        }
        ((FileUploadParams)ServiceLocator.getBean((String)"fileUploadParams")).setTempFolder(file);
    }

    public void setThresholdSize(int thresholdSize) {
        ((FileUploadParams)ServiceLocator.getBean((String)"fileUploadParams")).setThresholdSize(thresholdSize);
    }

    public void setFileSizeMax(long fileSizeMax) {
        ((FileUploadParams)ServiceLocator.getBean((String)"fileUploadParams")).setMaxFileUploadSize(fileSizeMax);
    }

    public static Map<String, List<DiskFileItem>> getFileItemsMap() {
        return (Map)BaseApplication.getRequest().getAttribute(FILE_ITEM_STREAMS);
    }

    public static DiskFileItem getFileItem(String name) {
        Map<String, List<DiskFileItem>> fileItemsMap = FileUploadRequestProcessor.getFileItemsMap();
        List<DiskFileItem> values = fileItemsMap == null ? null : fileItemsMap.get(name);
        return values == null || values.isEmpty() ? (DiskFileItem)null : values.get(0);
    }

    public static Iterable<DiskFileItem> getFileItems() {
        ArrayList<DiskFileItem> values = new ArrayList<DiskFileItem>();
        Map<String, List<DiskFileItem>> fileItemsMap = FileUploadRequestProcessor.getFileItemsMap();
        if (fileItemsMap != null) {
            for (List<DiskFileItem> l : fileItemsMap.values()) {
                values.addAll(l);
            }
        }
        return values;
    }

    private static void addParameterValue(Map<String, List<String>> parameters, String fieldName, String value) {
        List<String> values = parameters.get(fieldName);
        if (values == null) {
            values = new ArrayList<String>();
            parameters.put(fieldName, values);
        }
        values.add(value);
    }

    private static void addFileValue(Map<String, List<DiskFileItem>> files, String fieldName, DiskFileItem value) {
        List<DiskFileItem> values = files.get(fieldName);
        if (values == null) {
            values = new ArrayList<DiskFileItem>();
            files.put(fieldName, values);
        }
        values.add(value);
    }

    private static class MultipartRequestWrapper
    extends HttpServletRequestWrapper {
        private Map<String, String[]> parameters = new HashMap<String, String[]>();

        public MultipartRequestWrapper(HttpServletRequest request, Map<String, List<String>> parameters) {
            super(request);
            this.parameters.putAll(super.getParameterMap());
            for (String fieldName : parameters.keySet()) {
                List<String> values = parameters.get(fieldName);
                this.parameters.put(fieldName, values.toArray(new String[0]));
            }
        }

        public String getParameter(String name) {
            String[] values = this.parameters.get(name);
            return values == null || values.length == 0 ? (String)null : values[0];
        }

        public Map getParameterMap() {
            return this.parameters;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.parameters.keySet());
        }

        public String[] getParameterValues(String name) {
            return this.parameters.get(name);
        }
    }
}

