/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.resource;

import jetbrains.mps.webr.runtime.templateComponent.LinkUtil;

public enum ResourceDescriptor {
    JS("<script type=\"text/javascript\" src=\"", "\" " + LinkUtil.DEFER_STRING + "></script>", "bundledJavaScript", "js"),
    CSS("<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"", "\"/>", "bundledCss", "css");

    public String startHtml;
    public String endHtml;
    public String filePrefix;
    public String fileExt;

    private ResourceDescriptor(String startHtml, String endHtml, String filePrefix, String fileExt) {
        this.startHtml = startHtml;
        this.endHtml = endHtml;
        this.filePrefix = filePrefix;
        this.fileExt = fileExt;
    }

    public static ResourceDescriptor fromMimeType(String mimeType) {
        if (mimeType.indexOf("javascript") >= 0) {
            return JS;
        }
        if (mimeType.indexOf("css") >= 0) {
            return CSS;
        }
        throw new IllegalArgumentException("Unknown mimeType [" + mimeType + "]");
    }
}

