/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.staticHtml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.runtime.servlet.ServletUtil;
import jetbrains.mps.webr.runtime.staticHtml.HtmlScanner;
import jetbrains.mps.webr.runtime.staticHtml.StaticTemplate;
import org.apache.commons.io.IOUtils;

public class StaticHtmlUtil {
    private StaticHtmlUtil() {
    }

    static String getText(File file) {
        String text;
        try {
            text = IOUtils.toString((Reader)new FileReader(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return text;
    }

    static StaticTemplate getDefaultLayout(Map<String, Object> rootMap) {
        StaticTemplate template = null;
        File file = ServletUtil.getHtmlFile("default_layout.html");
        if (file != null) {
            String text = StaticHtmlUtil.getText(file);
            for (Map.Entry entry : SetSequence.fromSet(rootMap.entrySet())) {
                Object value = entry.getValue();
                if (!(value instanceof Boolean)) continue;
                entry.setValue(String.valueOf(value));
            }
            template = HtmlScanner.scan(text, rootMap);
        }
        return template;
    }

    public static String getDefaultLayoutText(String text, Map<String, Object> rootMap) {
        StaticTemplate defaultLayout = StaticHtmlUtil.getDefaultLayout(rootMap);
        if (defaultLayout != null) {
            text = defaultLayout.getText(text);
        }
        return text;
    }
}

