/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.uri.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestUtil {
    private DigestUtil() {
    }

    public static MessageDigest getMessageDigest() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
        return messageDigest;
    }

    public static String getHexByteString(byte b) {
        int hashByte = b;
        if (hashByte < 0) {
            hashByte += 128;
        }
        String hexString = Integer.toHexString(hashByte);
        while (hexString.length() < 2) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public static String getStringResult(byte[] hashBytes) {
        return DigestUtil.getStringResult(hashBytes, 4);
    }

    public static String getStringResult(byte[] hashBytes, int len) {
        StringBuilder builder = new StringBuilder();
        if (len <= 0) {
            len = hashBytes.length;
        }
        for (int i = 0; i < len; ++i) {
            builder.append(DigestUtil.getHexByteString(hashBytes[i]));
        }
        return builder.toString();
    }

    static String digest(byte[] bytes) {
        MessageDigest messageDigest = DigestUtil.getMessageDigest();
        byte[] hashBytes = messageDigest.digest(bytes);
        return DigestUtil.getStringResult(hashBytes);
    }

    static String digest(byte[] bytes, boolean isDebug) {
        MessageDigest messageDigest = DigestUtil.getMessageDigest();
        messageDigest.update(bytes);
        messageDigest.update((byte)(!isDebug ? 1 : 0));
        byte[] hashBytes = messageDigest.digest();
        return DigestUtil.getStringResult(hashBytes);
    }
}

