/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.util;

import java.util.LinkedList;
import name.fraser.neil.plaintext.Differ;

public final class WikiDiffUtil {
    private WikiDiffUtil() {
    }

    public static String toWikiDiff(String oldText, String newText) {
        Differ differ = new Differ();
        oldText = oldText != null ? oldText : "";
        newText = newText != null ? newText : "";
        LinkedList<Differ.Diff> diffs = differ.diffMain(oldText, newText);
        differ.diffCleanupSemantic(diffs);
        return WikiDiffUtil.diffWiki(differ, diffs);
    }

    private static String diffWiki(Differ differ, LinkedList<Differ.Diff> diffs) {
        differ.diffAddIndex(diffs);
        StringBuilder wiki = new StringBuilder();
        for (Differ.Diff aDiff : diffs) {
            switch (aDiff.operation) {
                case INSERT: {
                    wiki.append("+");
                    wiki.append("{color:green}");
                    break;
                }
                case DELETE: {
                    wiki.append("--");
                    wiki.append("{color:red}");
                    break;
                }
            }
            wiki.append(aDiff.text);
            switch (aDiff.operation) {
                case INSERT: {
                    wiki.append("{color}");
                    wiki.append("+");
                    break;
                }
                case DELETE: {
                    wiki.append("{color}");
                    wiki.append("--");
                    break;
                }
            }
        }
        return wiki.toString();
    }
}

