/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.controller;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.freemarker.ClasspathTemplateLoader;
import jetbrains.mps.webr.runtime.session.SessionVariableInitializer;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.requestProcessor.RequestProcessor;

public final class CentralManager {
    public static final String DEBUG_MODE = "jetrbains.mps.webr.debugMode";
    private Iterable<RequestProcessor> myRequestProcessors;
    private TypeConvertManager myTypeConvertManager;
    private Map<String, SessionVariableInitializer> mySessionVariableInitializers = new HashMap<String, SessionVariableInitializer>();
    private String myApplicationName;
    private String myAppicationVersion;
    private String myAppicationBuild;
    private Configuration myFreemarkerConfiguration;
    private boolean myFreemarkerConfigurationInited;
    private Boolean myBooleanDebugMode = null;
    private boolean myUsingStaticHtml;
    private boolean streamedBuilderContext = false;

    public boolean isStreamedBuilderContext() {
        return this.streamedBuilderContext;
    }

    public void setStreamedBuilderContext(boolean streamedBuilderContext) {
        this.streamedBuilderContext = streamedBuilderContext;
    }

    public Iterable<RequestProcessor> getRequestProcessors() {
        return this.myRequestProcessors;
    }

    public void setRequestProcessors(Iterable<RequestProcessor> requestProcessors) {
        this.myRequestProcessors = requestProcessors;
    }

    public TypeConvertManager getTypeConvertManager() {
        return this.myTypeConvertManager;
    }

    public void setTypeConvertManager(TypeConvertManager typeConvertManager) {
        this.myTypeConvertManager = typeConvertManager;
    }

    public Map<String, SessionVariableInitializer> getSessionVariableInitializers() {
        return this.mySessionVariableInitializers;
    }

    public void setSessionVariableInitializers(Map<String, SessionVariableInitializer> sessionVariableInitializers) {
        this.mySessionVariableInitializers = sessionVariableInitializers;
    }

    public Object getTransactionID() {
        return BaseApplication.getRequest().getSession().getId();
    }

    public String toIdString(Object object) {
        return this.myTypeConvertManager.toString(object);
    }

    Object fromIdString(String valueAsString, String className) {
        return this.myTypeConvertManager.fromString(valueAsString, className);
    }

    public String getApplicationName() {
        return this.myApplicationName;
    }

    public void setApplicationName(String applicationName) {
        this.myApplicationName = applicationName;
    }

    public String getAppicationVersion() {
        return this.myAppicationVersion;
    }

    public void setAppicationVersion(String appicationVersion) {
        this.myAppicationVersion = appicationVersion;
    }

    public String getAppicationBuild() {
        return this.myAppicationBuild;
    }

    public void setAppicationBuild(String appicationBuild) {
        this.myAppicationBuild = appicationBuild;
    }

    public void setFreemarkerConfiguration(Configuration freemarkerConfiguration) {
        this.myFreemarkerConfiguration = freemarkerConfiguration;
        this.myFreemarkerConfigurationInited = false;
    }

    public Configuration getFreemarkerConfiguration() throws IOException {
        if (!this.myFreemarkerConfigurationInited) {
            this.myFreemarkerConfiguration.setTemplateLoader((TemplateLoader)new ClasspathTemplateLoader(BaseApplication.getContextClassLoader()));
            this.myFreemarkerConfigurationInited = true;
        }
        return this.myFreemarkerConfiguration;
    }

    public void setDebugMode(String debugMode) {
        this.myBooleanDebugMode = this.myBooleanDebugMode == null && System.getProperty(DEBUG_MODE) != null ? Boolean.valueOf(Boolean.getBoolean(DEBUG_MODE)) : Boolean.valueOf(debugMode == null || !debugMode.equalsIgnoreCase("false"));
    }

    public boolean isAppDebugMode() {
        return this.myBooleanDebugMode;
    }

    public void setUsingStaticHtml(boolean usingStaticHtml) {
        this.myUsingStaticHtml = usingStaticHtml;
    }

    public boolean isUsingStaticHtml() {
        return this.myUsingStaticHtml;
    }
}

