/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.runtime.response;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.runtime.response.JsCommandResponse;
import webr.framework.textBuilder.TBuilderContext;

public class JsCompositeCommandResponse
extends JsCommandResponse {
    private static final Log log = LogFactory.getLog(JsCompositeCommandResponse.class);
    private Set<JsCommandResponse> myCommands = null;

    public void addCommand(JsCommandResponse command) {
        this.getCommands().add(command);
    }

    public void addCommand(JsCommandResponse command, TemplateComponent templateComponent) {
        if (command.contentNotGenerated()) {
            try {
                throw new Throwable();
            }
            catch (Throwable t) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Refusing to add command with not generated content.", t);
                }
            }
        } else if (this.getCommands().add(command)) {
            command.setTemplateComponent(templateComponent);
        }
    }

    public boolean isEmpty() {
        return this.myCommands == null || this.myCommands.isEmpty();
    }

    @Override
    public void doAction(HttpServletResponse response) throws IOException {
        if (this.isEmpty()) {
            throw new IllegalStateException("There're no commands inside composite command.");
        }
        super.doAction(response);
    }

    @Override
    protected void generateScript(TBuilderContext builderContext) {
        builderContext.append("<commands>");
        builderContext.appendNewLine();
        for (JsCommandResponse command : this.getCommands()) {
            command.doGenerateScript(builderContext);
        }
        builderContext.append("</commands>");
    }

    private Set<JsCommandResponse> getCommands() {
        if (this.myCommands == null) {
            this.myCommands = new LinkedHashSet<JsCommandResponse>();
        }
        return this.myCommands;
    }

    @Override
    public boolean isRequiresRebuildTemplateParameters() {
        for (JsCommandResponse c : this.getCommands()) {
            if (!c.isRequiresRebuildTemplateParameters()) continue;
            return true;
        }
        return false;
    }
}

