/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.textBuilder;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import jetbrains.mps.webr.runtime.util.ApplicationManager;
import org.apache.commons.lang.StringUtils;

public abstract class WebrBuffer {
    public static final boolean USE_CHAR_SEQUENCE;
    protected static String[] SPACES;
    protected static final String NL = "\n";
    protected byte indent;
    protected String encoding;

    public WebrBuffer() {
        this.encoding = StandardCharsets.UTF_8.toString();
    }

    public WebrBuffer(String encoding) {
        this.encoding = encoding;
    }

    public abstract void flushTo(Writer var1);

    public abstract void append(String var1);

    public abstract int getSize();

    void increaseIndent() {
        this.indent = (byte)(this.indent + 1);
    }

    void decreaseIndent() {
        this.indent = (byte)(this.indent - 1);
    }

    public void appendIndent() {
        if (ApplicationManager.isDebugMode()) {
            this.append(SPACES[this.indent]);
        }
    }

    public void appendNewLine() {
        this.append(NL);
    }

    public String getString() {
        StringWriter sw = new StringWriter(this.getSize());
        this.flushTo(sw);
        return sw.toString();
    }

    public CharSequence getCharSequence() {
        return this.getString();
    }

    static {
        String useCharSequenceValue = System.getProperty("webr.framework.textBuilder.useCharSequence");
        USE_CHAR_SEQUENCE = !System.getProperty("java.version").startsWith("9") && !"false".equals(useCharSequenceValue);
        int max = 128;
        SPACES = new String[max];
        for (int i = 0; i < max; ++i) {
            WebrBuffer.SPACES[i] = StringUtils.repeat((String)"  ", (int)i);
        }
    }
}

